/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer;

import java.util.Comparator;
import net.sourceforge.sqlexplorer.DataCache;
import net.sourceforge.sqlexplorer.SortedList;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;

public class AliasModel {
    private static IISQLAliasComparator iISQLAliasComparator = new IISQLAliasComparator();
    private SortedList sl;
    private DataCache cache;

    public AliasModel(DataCache c) {
        this.cache = c;
        this.sl = new SortedList(iISQLAliasComparator);
        this.sl.addAll(c.aliases());
    }

    public Object[] getElements() {
        return this.sl.toArray();
    }

    public void removeAlias(ISQLAlias as) {
        this.cache.removeAlias(as);
        this.sl.remove(as);
    }

    public void addAlias(ISQLAlias as) throws DuplicateObjectException {
        this.cache.addAlias(as);
        this.sl.add(as);
    }

    public ISQLAlias createAlias(IIdentifier id) {
        return this.cache.createAlias(id);
    }

    private static class IISQLAliasComparator
    implements Comparator {
        IISQLAliasComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((ISQLAlias)o1).getName().compareToIgnoreCase(((ISQLAlias)o2).getName());
        }
    }
}

