/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.Serializable;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;
import java.util.Vector;
import javax.sql.rowset.serial.SQLOutputImpl;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;
import javax.sql.rowset.serial.SerialRef;

public class SerialStruct
implements Struct,
Serializable,
Cloneable {
    private String SQLTypeName;
    private Object[] attribs;

    public SerialStruct(Struct struct, Map map) throws SerialException {
        try {
            this.SQLTypeName = new String(struct.getSQLTypeName());
            System.out.println("SQLTypeName: " + this.SQLTypeName);
            this.attribs = struct.getAttributes(map);
            this.mapToSerial(map);
        }
        catch (SQLException sQLException) {
            throw new SerialException(sQLException.getMessage());
        }
    }

    public SerialStruct(SQLData sQLData, Map map) throws SerialException {
        try {
            this.SQLTypeName = new String(sQLData.getSQLTypeName());
            Vector vector = new Vector();
            sQLData.writeSQL(new SQLOutputImpl(vector, map));
            this.attribs = vector.toArray();
            System.out.println("Dump: " + this.attribs[0] + "," + this.attribs[1]);
        }
        catch (SQLException sQLException) {
            throw new SerialException(sQLException.getMessage());
        }
    }

    public String getSQLTypeName() throws SerialException {
        return this.SQLTypeName;
    }

    public Object[] getAttributes() throws SerialException {
        return this.attribs;
    }

    public Object[] getAttributes(Map map) throws SerialException {
        return this.attribs;
    }

    private void mapToSerial(Map map) throws SerialException {
        try {
            int n = 0;
            while (n < this.attribs.length) {
                if (this.attribs[n] instanceof Struct) {
                    this.attribs[n] = new SerialStruct((Struct)this.attribs[n], map);
                } else if (this.attribs[n] instanceof SQLData) {
                    this.attribs[n] = new SerialStruct((SQLData)this.attribs[n], map);
                } else if (this.attribs[n] instanceof Blob) {
                    this.attribs[n] = new SerialBlob((Blob)this.attribs[n]);
                } else if (this.attribs[n] instanceof Clob) {
                    this.attribs[n] = new SerialClob((Clob)this.attribs[n]);
                } else if (this.attribs[n] instanceof Ref) {
                    this.attribs[n] = new SerialRef((Ref)this.attribs[n]);
                } else if (this.attribs[n] instanceof Array) {
                    this.attribs[n] = new SerialArray((Array)this.attribs[n], map);
                }
                ++n;
            }
        }
        catch (SQLException sQLException) {
            throw new SerialException(sQLException.getMessage());
        }
    }
}

