/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialException;

public class SerialClob
implements Clob,
Serializable,
Cloneable {
    char[] buf;
    long len;
    long origLen;

    public SerialClob(Clob clob) throws SerialException, SQLException {
        this.origLen = this.len = clob.length();
        this.buf = new char[(int)this.len];
        int n = 0;
        int n2 = 0;
        BufferedReader bufferedReader = new BufferedReader(clob.getCharacterStream());
        try {
            do {
                n = bufferedReader.read(this.buf, n2, (int)(this.len - (long)n2));
                n2 += n;
            } while (n > 0);
        }
        catch (IOException iOException) {
            throw new SerialException("SerialClob: " + iOException.getMessage());
        }
    }

    public long length() throws SerialException {
        return this.len;
    }

    public Reader getCharacterStream() throws SerialException {
        return new CharArrayReader(this.buf);
    }

    public InputStream getAsciiStream() throws SerialException {
        throw new UnsupportedOperationException();
    }

    public String getSubString(long l, int n) throws SerialException {
        if (l < 0L || (long)n > this.len || l + (long)n > this.len) {
            throw new SerialException("Invalid Arguments");
        }
        return new String(this.buf, (int)l, n);
    }

    /*
     * Unable to fully structure code
     */
    public long position(String var1_1, long var2_2) throws SerialException {
        if (var2_2 < 0L || var2_2 > this.len || var2_2 + (long)var1_1.length() > this.len) {
            throw new SerialException("Invalid Arguments");
        }
        var4_3 = var1_1.toCharArray();
        var5_4 = (int)(var2_2 - 1L);
        var8_5 = 0;
        var9_6 = var4_3.length;
        if (var2_2 >= 1L && var2_2 <= this.len) ** GOTO lbl14
        return -1L;
lbl-1000:
        // 1 sources

        {
            var8_5 = 0;
            var6_7 = var5_4 + 1;
            while (var4_3[var8_5++] == this.buf[var5_4++]) {
                if ((long)var8_5 != var9_6) continue;
                return var6_7;
            }
lbl14:
            // 2 sources

            ** while ((long)var5_4 < this.len)
        }
lbl15:
        // 1 sources

        return -1L;
    }

    public long position(Clob clob, long l) throws SerialException {
        throw new UnsupportedOperationException();
    }

    public int setString(long l, String string) throws SerialException {
        return this.setString(l, string, 0, string.length());
    }

    public int setString(long l, String string, int n, int n2) throws SerialException {
        int n3 = 0;
        if ((long)n2 > this.origLen) {
            throw new SerialException("Buffer is not sufficient to hold the value");
        }
        String string2 = string.substring(n);
        char[] cArray = string2.toCharArray();
        n3 = 0;
        while (n3 < n2) {
            this.buf[(int)l + n3] = cArray[n + n3];
            ++n3;
        }
        return n3;
    }

    public OutputStream setAsciiStream(long l) throws SerialException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)l);
        return byteArrayOutputStream;
    }

    public Writer setCharacterStream(long l) throws SerialException {
        CharArrayWriter charArrayWriter = new CharArrayWriter((int)l);
        return charArrayWriter;
    }

    public void truncate(long l) throws SerialException {
        if (l > this.len) {
            throw new SerialException("Length more than what can be truncated");
        }
        this.len = l;
        this.buf = this.getSubString(0L, (int)this.len).toCharArray();
    }
}

