/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset;

import com.sun.rowset.internal.ColInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import javax.sql.RowSetMetaData;

public class RowSetMetaDataImpl
implements RowSetMetaData,
Serializable {
    private int colCount;
    private ColInfo[] colInfo;

    private void checkColRange(int n) throws SQLException {
        if (n <= 0 || n > this.colCount) {
            throw new SQLException("Invalid column index");
        }
    }

    public void setColumnCount(int n) throws SQLException {
        if (n <= 0) {
            throw new SQLException("Invalid column count");
        }
        this.colCount = n;
        this.colInfo = new ColInfo[this.colCount + 1];
        int n2 = 1;
        while (n2 <= this.colCount) {
            this.colInfo[n2] = new ColInfo();
            ++n2;
        }
    }

    public void setAutoIncrement(int n, boolean bl) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].autoIncrement = bl;
    }

    public void setCaseSensitive(int n, boolean bl) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].caseSensitive = bl;
    }

    public void setSearchable(int n, boolean bl) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].searchable = bl;
    }

    public void setCurrency(int n, boolean bl) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].currency = bl;
    }

    public void setNullable(int n, int n2) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].nullable = n2;
    }

    public void setSigned(int n, boolean bl) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].signed = bl;
    }

    public void setColumnDisplaySize(int n, int n2) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].columnDisplaySize = n2;
    }

    public void setColumnLabel(int n, String string) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].columnLabel = string != null ? new String(string) : new String("");
    }

    public void setColumnName(int n, String string) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].columnName = new String(string);
    }

    public void setSchemaName(int n, String string) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].schemaName = string != null ? new String(string) : new String("");
    }

    public void setPrecision(int n, int n2) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].colPrecision = n2;
    }

    public void setScale(int n, int n2) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].colScale = n2;
    }

    public void setTableName(int n, String string) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].tableName = string != null ? new String(string) : new String("");
    }

    public void setCatalogName(int n, String string) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].catName = string != null ? new String(string) : new String("");
    }

    public void setColumnType(int n, int n2) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].colType = n2;
    }

    public void setColumnTypeName(int n, String string) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].colTypeName = new String(string);
    }

    public int getColumnCount() throws SQLException {
        return this.colCount;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].autoIncrement;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].caseSensitive;
    }

    public boolean isSearchable(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].searchable;
    }

    public boolean isCurrency(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].currency;
    }

    public int isNullable(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].nullable;
    }

    public boolean isSigned(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].signed;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].columnDisplaySize;
    }

    public String getColumnLabel(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].columnLabel;
    }

    public String getColumnName(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].columnName;
    }

    public String getSchemaName(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].schemaName;
    }

    public int getPrecision(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].colPrecision;
    }

    public int getScale(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].colScale;
    }

    public String getTableName(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].tableName;
    }

    public String getCatalogName(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].catName;
    }

    public int getColumnType(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].colType;
    }

    public String getColumnTypeName(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].colTypeName;
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.checkColRange(n);
        return true;
    }

    public boolean isWritable(int n) throws SQLException {
        this.checkColRange(n);
        return false;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return true;
    }

    public String getColumnClassName(int n) throws SQLException {
        String string = new String().getClass().getName();
        int n2 = this.getColumnType(n);
        switch (n2) {
            case 2: 
            case 3: {
                string = new BigDecimal(0.0).getClass().getName();
                break;
            }
            case -7: {
                string = new Boolean(false).getClass().getName();
                break;
            }
            case -6: {
                string = new Byte("0").getClass().getName();
                break;
            }
            case 5: {
                string = new Short("0").getClass().getName();
                break;
            }
            case 4: {
                string = new Integer(0).getClass().getName();
                break;
            }
            case -5: {
                string = new Long(0L).getClass().getName();
                break;
            }
            case 7: {
                string = new Float(0.0f).getClass().getName();
                break;
            }
            case 6: 
            case 8: {
                string = new Double(0.0).getClass().getName();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] byArray = new byte[]{};
                string = byArray.getClass().getName();
                break;
            }
            case 91: {
                string = new Date(123456L).getClass().getName();
                break;
            }
            case 92: {
                string = new Time(123456L).getClass().getName();
                break;
            }
            case 93: {
                string = new Timestamp(123456L).getClass().getName();
                break;
            }
            case 2004: {
                byte[] byArray = new byte[]{};
                string = byArray.getClass().getName();
                break;
            }
            case 2005: {
                char[] cArray = new char[]{};
                string = cArray.getClass().getName();
            }
        }
        return string;
    }
}

