/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.internal;

import com.sun.rowset.CachedRowSetImpl;
import com.sun.rowset.internal.CachedRowSetReader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.RowSetInternal;
import javax.sql.RowSetWriter;
import javax.sql.rowset.CachedRowSet;

public class CachedRowSetWriter
implements RowSetWriter,
Serializable {
    private Connection con;
    private String selectCmd;
    private String updateCmd;
    private String updateWhere;
    private String deleteCmd;
    private String deleteWhere;
    private String insertCmd;
    private int[] keyCols;
    private Object[] params;
    private CachedRowSetReader reader;
    private ResultSetMetaData callerMd;
    private int callerColumnCount;

    public boolean writeData(RowSetInternal rowSetInternal) throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        PreparedStatement preparedStatement = null;
        CachedRowSetImpl cachedRowSetImpl = (CachedRowSetImpl)rowSetInternal;
        this.con = this.reader.connect(rowSetInternal);
        if (this.con == null) {
            throw new SQLException("Unable to get Connection");
        }
        if (this.con.getAutoCommit()) {
            this.con.setAutoCommit(false);
        }
        this.con.setTransactionIsolation(cachedRowSetImpl.getTransactionIsolation());
        this.initSQLStatements(cachedRowSetImpl);
        preparedStatement = this.con.prepareStatement(this.insertCmd);
        if (this.callerColumnCount < 1) {
            if (this.reader.getCloseConnection()) {
                this.con.close();
            }
            return true;
        }
        bl2 = cachedRowSetImpl.getShowDeleted();
        cachedRowSetImpl.setShowDeleted(true);
        cachedRowSetImpl.beforeFirst();
        while (cachedRowSetImpl.next()) {
            if (cachedRowSetImpl.rowDeleted() && cachedRowSetImpl.rowInserted()) continue;
            if (cachedRowSetImpl.rowDeleted()) {
                bl = this.deleteOriginalRow(cachedRowSetImpl);
                if (!bl) continue;
                break;
            }
            if (!cachedRowSetImpl.rowInserted() ? cachedRowSetImpl.rowUpdated() && (bl = this.updateOriginalRow(cachedRowSetImpl)) : (bl = this.insertNewRow(cachedRowSetImpl, preparedStatement))) break;
        }
        preparedStatement.close();
        cachedRowSetImpl.setShowDeleted(bl2);
        if (bl) {
            this.con.rollback();
            if (this.reader.getCloseConnection()) {
                this.con.close();
            }
            return false;
        }
        this.con.commit();
        if (this.reader.getCloseConnection()) {
            this.con.close();
        }
        return true;
    }

    private boolean updateOriginalRow(CachedRowSet cachedRowSet) throws SQLException {
        int n = 0;
        int n2 = 0;
        ResultSet resultSet = cachedRowSet.getOriginalRow();
        resultSet.next();
        try {
            this.updateWhere = this.buildWhereClause(this.updateWhere, resultSet);
            PreparedStatement preparedStatement = this.con.prepareStatement(this.selectCmd + this.updateWhere);
            n = 0;
            while (n < this.keyCols.length) {
                if (this.params[n] != null) {
                    preparedStatement.setObject(++n2, this.params[n]);
                }
                ++n;
            }
            try {
                preparedStatement.setMaxRows(cachedRowSet.getMaxRows());
                preparedStatement.setMaxFieldSize(cachedRowSet.getMaxFieldSize());
                preparedStatement.setEscapeProcessing(cachedRowSet.getEscapeProcessing());
                preparedStatement.setQueryTimeout(cachedRowSet.getQueryTimeout());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ResultSet resultSet2 = preparedStatement.executeQuery();
            if (resultSet2.next()) {
                if (resultSet2.next()) {
                    System.out.println("Cannot uniquely id. row");
                    return true;
                }
                resultSet2.close();
                preparedStatement.close();
                int n3 = 0;
                Vector<Integer> vector = new Vector<Integer>();
                String string = new String(this.updateCmd);
                boolean bl = true;
                n = 1;
                while (n <= this.callerColumnCount) {
                    Object object = resultSet.getObject(n);
                    Object object2 = cachedRowSet.getObject(n);
                    if (object != null || object2 != null) {
                        if (object == null || object2 == null || !object.equals(object2)) {
                            if (!bl) {
                                string = string + ", ";
                            }
                            string = string + cachedRowSet.getMetaData().getColumnName(n);
                            vector.add(new Integer(n));
                            string = string + " = ? ";
                            bl = false;
                        } else if (object.equals(object2)) {
                            ++n3;
                        }
                    }
                    ++n;
                }
                if (!bl && vector.size() == 0 || n3 == this.callerColumnCount) {
                    return false;
                }
                string = string + this.updateWhere;
                preparedStatement = this.con.prepareStatement(string);
                n = 0;
                while (n < vector.size()) {
                    Object object = cachedRowSet.getObject((Integer)vector.get(n));
                    if (object != null) {
                        preparedStatement.setObject(n + 1, object);
                    } else {
                        preparedStatement.setNull(n + 1, cachedRowSet.getMetaData().getColumnType(n + 1));
                    }
                    ++n;
                }
                n2 = n;
                n = 0;
                while (n < this.keyCols.length) {
                    if (this.params[n] != null) {
                        preparedStatement.setObject(++n2, this.params[n]);
                    }
                    ++n;
                }
                n = preparedStatement.executeUpdate();
                if (n != 1) {
                    System.err.println("excuteUpdate ret: " + n);
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException.getMessage());
            return true;
        }
    }

    private boolean insertNewRow(CachedRowSet cachedRowSet, PreparedStatement preparedStatement) throws SQLException {
        int n = 0;
        try {
            n = 1;
            while (n <= cachedRowSet.getMetaData().getColumnCount()) {
                Object object = cachedRowSet.getObject(n);
                if (object != null) {
                    if (cachedRowSet.getMetaData().getColumnType(n) == 5) {
                        preparedStatement.setShort(n, (Short)object);
                    } else {
                        preparedStatement.setObject(n, object);
                    }
                } else {
                    preparedStatement.setNull(n, cachedRowSet.getMetaData().getColumnType(n));
                }
                ++n;
            }
            n = preparedStatement.executeUpdate();
            if (n != 1) {
                System.err.println("excuteUpdate ret: " + n);
                return true;
            }
            return false;
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException.getMessage());
            return true;
        }
    }

    private boolean deleteOriginalRow(CachedRowSet cachedRowSet) throws SQLException {
        int n = 0;
        ResultSet resultSet = cachedRowSet.getOriginalRow();
        resultSet.next();
        this.deleteWhere = this.buildWhereClause(this.deleteWhere, resultSet);
        PreparedStatement preparedStatement = this.con.prepareStatement(this.selectCmd + this.deleteWhere);
        int n2 = 0;
        while (n2 < this.keyCols.length) {
            if (this.params[n2] != null) {
                preparedStatement.setObject(++n, this.params[n2]);
            }
            ++n2;
        }
        try {
            preparedStatement.setMaxRows(cachedRowSet.getMaxRows());
            preparedStatement.setMaxFieldSize(cachedRowSet.getMaxFieldSize());
            preparedStatement.setEscapeProcessing(cachedRowSet.getEscapeProcessing());
            preparedStatement.setQueryTimeout(cachedRowSet.getQueryTimeout());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResultSet resultSet2 = preparedStatement.executeQuery();
        if (resultSet2.next()) {
            if (resultSet2.next()) {
                return true;
            }
            resultSet2.close();
            preparedStatement.close();
            String string = this.deleteCmd + this.deleteWhere;
            preparedStatement = this.con.prepareStatement(string);
            n = 0;
            n2 = 0;
            while (n2 < this.keyCols.length) {
                if (this.params[n2] != null) {
                    preparedStatement.setObject(++n, this.params[n2]);
                }
                ++n2;
            }
            if (preparedStatement.executeUpdate() != 1) {
                return true;
            }
        } else {
            return true;
        }
        preparedStatement.close();
        return false;
    }

    public void setReader(CachedRowSetReader cachedRowSetReader) throws SQLException {
        this.reader = cachedRowSetReader;
    }

    public CachedRowSetReader getReader() throws SQLException {
        return this.reader;
    }

    private void initSQLStatements(CachedRowSet cachedRowSet) throws SQLException {
        this.callerMd = cachedRowSet.getMetaData();
        this.callerColumnCount = this.callerMd.getColumnCount();
        if (this.callerColumnCount < 1) {
            return;
        }
        String string = cachedRowSet.getTableName();
        if (string == null && ((string = this.callerMd.getTableName(1)) == null || string.length() == 0)) {
            throw new SQLException("writeData cannot determine the table name.");
        }
        String string2 = this.callerMd.getCatalogName(1);
        String string3 = this.callerMd.getSchemaName(1);
        DatabaseMetaData databaseMetaData = this.con.getMetaData();
        this.selectCmd = "SELECT ";
        int n = 1;
        while (n <= this.callerColumnCount) {
            this.selectCmd = this.selectCmd + this.callerMd.getColumnName(n);
            this.selectCmd = n < this.callerMd.getColumnCount() ? this.selectCmd + ", " : this.selectCmd + " ";
            ++n;
        }
        this.selectCmd = this.selectCmd + "FROM " + this.buildTableName(databaseMetaData, string2, string3, string);
        this.updateCmd = "UPDATE " + this.buildTableName(databaseMetaData, string2, string3, string);
        this.updateCmd = this.updateCmd + "SET ";
        this.insertCmd = "INSERT INTO " + this.buildTableName(databaseMetaData, string2, string3, string);
        this.insertCmd = this.insertCmd + "(";
        n = 1;
        while (n <= this.callerColumnCount) {
            this.insertCmd = this.insertCmd + this.callerMd.getColumnName(n);
            this.insertCmd = n < this.callerMd.getColumnCount() ? this.insertCmd + ", " : this.insertCmd + ") VALUES (";
            ++n;
        }
        n = 1;
        while (n <= this.callerColumnCount) {
            this.insertCmd = this.insertCmd + "?";
            this.insertCmd = n < this.callerColumnCount ? this.insertCmd + ", " : this.insertCmd + ")";
            ++n;
        }
        this.deleteCmd = "DELETE FROM " + this.buildTableName(databaseMetaData, string2, string3, string);
        this.buildKeyDesc(cachedRowSet);
    }

    private String buildTableName(DatabaseMetaData databaseMetaData, String string, String string2, String string3) throws SQLException {
        String string4 = new String();
        string = string.trim();
        string2 = string2.trim();
        string3 = string3.trim();
        if (databaseMetaData.isCatalogAtStart()) {
            if (string != null && string.length() > 0) {
                string4 = string4 + string + databaseMetaData.getCatalogSeparator();
            }
            if (string2 != null && string2.length() > 0) {
                string4 = string4 + string2 + ".";
            }
            string4 = string4 + string3;
        } else {
            if (string2 != null && string2.length() > 0) {
                string4 = string4 + string2 + ".";
            }
            string4 = string4 + string3;
            if (string != null && string.length() > 0) {
                string4 = string4 + databaseMetaData.getCatalogSeparator() + string;
            }
        }
        string4 = string4 + " ";
        return string4;
    }

    private void buildKeyDesc(CachedRowSet cachedRowSet) throws SQLException {
        this.keyCols = cachedRowSet.getKeyColumns();
        if (this.keyCols == null || this.keyCols.length == 0) {
            this.keyCols = new int[this.callerColumnCount];
            int n = 0;
            while (n < this.keyCols.length) {
                this.keyCols[n++] = n;
            }
        }
        this.params = new Object[this.keyCols.length];
    }

    private String buildWhereClause(String string, ResultSet resultSet) throws SQLException {
        string = "WHERE ";
        int n = 0;
        while (n < this.keyCols.length) {
            if (n > 0) {
                string = string + "AND ";
            }
            string = string + this.callerMd.getColumnName(this.keyCols[n]);
            this.params[n] = resultSet.getObject(this.keyCols[n]);
            string = resultSet.wasNull() ? string + " IS NULL " : string + " = ? ";
            ++n;
        }
        return string;
    }
}

