/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverProperty;

public class SQLDriverPropertyCollection {
    private final Map _objectsIndexMap = new TreeMap();
    private final List _objectsList = new ArrayList();

    public synchronized void clear() {
        this._objectsIndexMap.clear();
        this._objectsList.clear();
    }

    public int size() {
        return this._objectsList.size();
    }

    public synchronized void applyTo(Properties props) {
        int limit = this.size();
        for (int i = 0; i < limit; ++i) {
            String value;
            SQLDriverProperty sdp = this.getDriverProperty(i);
            if (!sdp.isSpecified() || (value = sdp.getValue()) == null) continue;
            props.put(sdp.getName(), value);
        }
    }

    public synchronized SQLDriverProperty[] getDriverProperties() {
        SQLDriverProperty[] ar = new SQLDriverProperty[this._objectsList.size()];
        return this._objectsList.toArray(ar);
    }

    public SQLDriverProperty getDriverProperty(int idx) {
        return (SQLDriverProperty)this._objectsList.get(idx);
    }

    public synchronized void setDriverProperties(SQLDriverProperty[] values) {
        this._objectsIndexMap.clear();
        this._objectsList.clear();
        for (int i = 0; i < values.length; ++i) {
            this._objectsList.add(values[i]);
            this._objectsIndexMap.put(values[i].getName(), values[i]);
        }
    }

    public synchronized void setDriverProperty(int idx, SQLDriverProperty value) {
        this._objectsList.add(idx, value);
        this._objectsIndexMap.put(value.getName(), value);
    }

    public synchronized void applyDriverPropertynfo(DriverPropertyInfo[] infoAr) {
        for (int i = 0; i < infoAr.length; ++i) {
            SQLDriverProperty sdp = (SQLDriverProperty)this._objectsIndexMap.get(infoAr[i].name);
            if (sdp == null) {
                sdp = new SQLDriverProperty(infoAr[i]);
                this._objectsIndexMap.put(sdp.getName(), sdp);
                this._objectsList.add(sdp);
            }
            sdp.setDriverPropertyInfo(infoAr[i]);
        }
    }

    public static interface IPropertyNames {
        public static final String DRIVER_PROPERTIES = "driverProperties";
    }
}

