/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.BaseAction;
import net.sourceforge.squirrel_sql.fw.gui.action.IHasJDesktopPane;

public abstract class TileInternalFramesAction
extends BaseAction
implements IHasJDesktopPane {
    private JDesktopPane _desktop;

    public TileInternalFramesAction() {
        this((JDesktopPane)null);
    }

    public TileInternalFramesAction(JDesktopPane desktop) {
        super("Tile");
        this.setJDesktopPane(desktop);
    }

    public void setJDesktopPane(JDesktopPane value) {
        this._desktop = value;
    }

    public void actionPerformed(ActionEvent evt) {
        JInternalFrame[] children;
        int cells;
        if (this._desktop != null && (cells = (children = GUIUtils.getNonMinimizedNonToolWindows(this._desktop.getAllFrames())).length) > 0) {
            RowColumnCount rcc = this.getRowColumnCount(cells);
            int rows = rcc._rowCount;
            int cols = rcc._columnCount;
            Dimension desktopSize = this._desktop.getSize();
            int width = desktopSize.width / cols;
            int height = desktopSize.height / rows;
            int xPos = 0;
            int yPos = 0;
            for (int y = 0; y < rows; ++y) {
                int idx;
                for (int x = 0; x < cols && (idx = y + x * rows) < cells; ++x) {
                    JInternalFrame frame = children[idx];
                    if (frame.isClosed()) continue;
                    if (frame.isIcon()) {
                        try {
                            frame.setIcon(false);
                        }
                        catch (PropertyVetoException ignore) {}
                    } else if (frame.isMaximum()) {
                        try {
                            frame.setMaximum(false);
                        }
                        catch (PropertyVetoException ignore) {
                            // empty catch block
                        }
                    }
                    frame.reshape(xPos, yPos, width, height);
                    xPos += width;
                }
                xPos = 0;
                yPos += height;
            }
        }
    }

    protected abstract RowColumnCount getRowColumnCount(int var1);

    public static final class RowColumnCount {
        protected final int _rowCount;
        protected final int _columnCount;

        public RowColumnCount(int rowCount, int columnCount) {
            this._rowCount = rowCount;
            this._columnCount = columnCount;
        }
    }

    private static interface i18n {
        public static final String TITLE = "Tile";
    }
}

