/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JInternalFrame;
import net.sourceforge.squirrel_sql.fw.gui.action.BaseAction;
import net.sourceforge.squirrel_sql.fw.gui.action.SelectInternalFrameCommand;

public class SelectInternalFrameAction
extends BaseAction
implements PropertyChangeListener {
    private static final String FRAME_PTR = "FRAME_PTR";
    private static final int MAX_TITLE_LENGTH = 50;

    public SelectInternalFrameAction(JInternalFrame child) {
        this(child, null);
    }

    public SelectInternalFrameAction(JInternalFrame child, String title) {
        super(SelectInternalFrameAction.getTitle(child, title));
        this.putValue(FRAME_PTR, child);
        this.putValue("ShortDescription", "Active window");
        if (title != null && title.length() > 0) {
            child.addPropertyChangeListener("title", this);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        JInternalFrame fr = this.getInternalFrame();
        if (fr != null) {
            new SelectInternalFrameCommand(fr).execute();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.putValue("Name", this.getInternalFrame().getTitle());
    }

    private JInternalFrame getInternalFrame() throws IllegalStateException {
        JInternalFrame fr = (JInternalFrame)this.getValue(FRAME_PTR);
        if (fr == null) {
            throw new IllegalStateException("No JInternalFrame associated with SelectInternalFrameAction");
        }
        return fr;
    }

    private static String getTitle(JInternalFrame child, String title) {
        if (child == null) {
            throw new IllegalArgumentException("null JInternalFrame passed");
        }
        String myTitle = title;
        myTitle = title != null && title.length() > 0 ? title : child.getTitle();
        if (myTitle.length() > 50) {
            myTitle = myTitle.substring(0, 50) + "...";
        }
        return myTitle;
    }

    private static interface i18n {
        public static final String SHORT_DESCRIPTION = "Active window";
    }
}

