/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.gui.BasePopupMenu;
import net.sourceforge.squirrel_sql.fw.gui.action.BaseAction;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class TextPopupMenu
extends BasePopupMenu {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(class$net$sourceforge$squirrel_sql$fw$gui$TextPopupMenu == null ? (class$net$sourceforge$squirrel_sql$fw$gui$TextPopupMenu = TextPopupMenu.class$("net.sourceforge.squirrel_sql.fw.gui.TextPopupMenu")) : class$net$sourceforge$squirrel_sql$fw$gui$TextPopupMenu);
    private JTextComponent _comp;
    private final JMenuItem[] _menuItems = new JMenuItem[4];
    private CutAction _cut = new CutAction();
    private CopyAction _copy = new CopyAction();
    private PasteAction _paste = new PasteAction();
    private SelectAllAction _select = new SelectAllAction();
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$gui$TextPopupMenu;

    public TextPopupMenu() {
        this.addMenuEntries();
    }

    protected void setItemAction(int optionType, Action action) {
        if (optionType < 0 || optionType > 3) {
            throw new IllegalArgumentException("Invalid option type: " + optionType);
        }
        if (action == null) {
            throw new IllegalArgumentException("Action == null");
        }
        int idx = this.getComponentIndex(this._menuItems[optionType]);
        this.remove(idx);
        this.insert(action, idx);
        this._menuItems[optionType] = (JMenuItem)this.getComponent(idx);
    }

    private void addMenuEntries() {
        this._menuItems[0] = this.add(this._cut);
        this._menuItems[1] = this.add(this._copy);
        this._menuItems[2] = this.add(this._paste);
        this.addSeparator();
        this._menuItems[3] = this.add(this._select);
    }

    public void setTextComponent(JTextComponent value) {
        this._comp = value;
    }

    public void show(Component invoker, int x, int y) {
        this.updateActions();
        super.show(invoker, x, y);
    }

    public void show(MouseEvent evt) {
        this.updateActions();
        super.show(evt);
    }

    protected void updateActions() {
        boolean isEditable = this._comp != null && this._comp.isEditable();
        this._cut.setEnabled(isEditable);
        this._paste.setEnabled(isEditable);
    }

    protected JTextComponent getTextComponent() {
        return this._comp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class SelectAllAction
    extends BaseAction {
        SelectAllAction() {
            super(s_stringMgr.getString("TextPopupMenu.selectall"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (TextPopupMenu.this._comp != null) {
                TextPopupMenu.this._comp.selectAll();
            }
        }
    }

    protected class PasteAction
    extends BaseAction {
        PasteAction() {
            super(s_stringMgr.getString("TextPopupMenu.paste"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (TextPopupMenu.this._comp != null) {
                TextPopupMenu.this._comp.paste();
            }
        }
    }

    protected class CopyAction
    extends BaseAction {
        CopyAction() {
            super(s_stringMgr.getString("TextPopupMenu.copy"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (TextPopupMenu.this._comp != null) {
                TextPopupMenu.this._comp.copy();
            }
        }
    }

    protected class CutAction
    extends BaseAction {
        CutAction() {
            super(s_stringMgr.getString("TextPopupMenu.cut"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (TextPopupMenu.this._comp != null) {
                TextPopupMenu.this._comp.cut();
            }
        }
    }

    public static interface IOptionTypes {
        public static final int CUT = 0;
        public static final int COPY = 1;
        public static final int PASTE = 2;
        public static final int SELECT_ALL = 3;
        public static final int LAST_ENTRY = 3;
    }
}

