/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Font;

public class FontInfo
implements Cloneable {
    private static String DEFAULT_FAMILY = "Monospaced";
    private String _familyName;
    private boolean _isBold;
    private boolean _isItalic;
    private int _size;

    public FontInfo() {
        this.setFamily(DEFAULT_FAMILY);
        this.setSize(12);
    }

    public FontInfo(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null Font passed");
        }
        this.setFont(font);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public String getFamily() {
        return this._familyName;
    }

    public void setFamily(String value) {
        this._familyName = value != null ? value : DEFAULT_FAMILY;
    }

    public boolean isBold() {
        return this._isBold;
    }

    public void setIsBold(boolean value) {
        this._isBold = value;
    }

    public boolean isItalic() {
        return this._isItalic;
    }

    public void setIsItalic(boolean value) {
        this._isItalic = value;
    }

    public int getSize() {
        return this._size;
    }

    public void setSize(int value) {
        this._size = value;
    }

    public void setFont(Font font) throws IllegalArgumentException {
        if (font == null) {
            throw new IllegalArgumentException("Null Font passed");
        }
        this._familyName = font.getFamily();
        this._isBold = font.isBold();
        this._isItalic = font.isItalic();
        this._size = font.getSize();
    }

    public boolean doesFontMatch(Font font) {
        if (font == null) {
            return false;
        }
        return font.getFamily().equals(this._familyName) && font.getSize() == this.getSize() && font.getStyle() == this.generateStyle();
    }

    public int generateStyle() {
        int style = 0;
        if (!this._isBold && !this._isItalic) {
            style = 0;
        } else {
            if (this._isBold) {
                style |= 1;
            }
            if (this._isItalic) {
                style |= 2;
            }
        }
        return style;
    }

    public Font createFont() {
        return new Font(this._familyName, this.generateStyle(), this._size);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this._familyName).append(", " + this._size);
        if (this._isBold) {
            buf.append(", bold");
        }
        if (this._isItalic) {
            buf.append(", italic");
        }
        return buf.toString();
    }

    public static interface IPropertyNames {
        public static final String FAMILY = "family";
        public static final String IS_BOLD = "isBold";
        public static final String IS_ITALIC = "isItalic";
        public static final String SIZE = "size";
    }
}

