/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.sourceforge.squirrel_sql.fw.gui.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.resources.LibraryResources;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ButtonTableHeader
extends JTableHeader {
    private static ILogger s_log = LoggerController.createLogger(class$net$sourceforge$squirrel_sql$fw$gui$ButtonTableHeader == null ? (class$net$sourceforge$squirrel_sql$fw$gui$ButtonTableHeader = ButtonTableHeader.class$("net.sourceforge.squirrel_sql.fw.gui.ButtonTableHeader")) : class$net$sourceforge$squirrel_sql$fw$gui$ButtonTableHeader);
    private static Icon s_ascIcon;
    private static Icon s_descIcon;
    private TableDataListener _dataListener = new TableDataListener();
    private boolean _pressed = false;
    private boolean _dragged = false;
    private int _pressedColumnIdx = -1;
    private Icon _currentSortedColumnIcon;
    private int _currentlySortedColumnIdx = -1;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$gui$ButtonTableHeader;

    public ButtonTableHeader() {
        this.setDefaultRenderer(new ButtonTableRenderer(this.getFont()));
        HeaderListener hl = new HeaderListener();
        this.addMouseListener(hl);
        this.addMouseMotionListener(hl);
    }

    public void setTable(JTable table) {
        SortableTableModel model;
        TableModel obj;
        JTable oldTable = this.getTable();
        if (oldTable != null && (obj = oldTable.getModel()) instanceof SortableTableModel) {
            model = (SortableTableModel)obj;
            model.getActualModel().removeTableModelListener(this._dataListener);
        }
        super.setTable(table);
        if (table != null && (obj = table.getModel()) instanceof SortableTableModel) {
            model = (SortableTableModel)obj;
            model.getActualModel().addTableModelListener(this._dataListener);
        }
        this._currentSortedColumnIcon = null;
        this._currentlySortedColumnIdx = -1;
    }

    public String getToolTipText(MouseEvent e) {
        int col = this.columnAtPoint(e.getPoint());
        String retStr = null;
        if (col >= 0) {
            TableColumn tcol = this.getColumnModel().getColumn(col);
            int colWidth = tcol.getWidth();
            TableCellRenderer h = tcol.getHeaderRenderer();
            if (h == null) {
                h = this.getDefaultRenderer();
            }
            Component c = h.getTableCellRendererComponent(this.table, tcol.getHeaderValue(), false, false, -1, col);
            int prefWidth = c.getPreferredSize().width;
            if (prefWidth > colWidth) {
                retStr = tcol.getHeaderValue().toString();
            }
        }
        return retStr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            LibraryResources rsrc = new LibraryResources();
            s_descIcon = rsrc.getIcon("table.descending");
            s_ascIcon = rsrc.getIcon("table.ascending");
        }
        catch (Exception ex) {
            s_log.error("Error retrieving icons", ex);
        }
    }

    protected class ButtonTableRenderer
    implements TableCellRenderer {
        JButton _buttonRaised = new JButton();
        JButton _buttonLowered;

        ButtonTableRenderer(Font font) {
            this._buttonRaised.setMargin(new Insets(0, 0, 0, 0));
            this._buttonRaised.setFont(font);
            this._buttonLowered = new JButton();
            this._buttonLowered.setMargin(new Insets(0, 0, 0, 0));
            this._buttonLowered.setFont(font);
            this._buttonLowered.getModel().setArmed(true);
            this._buttonLowered.getModel().setPressed(true);
            this._buttonLowered.setMinimumSize(new Dimension(50, 25));
            this._buttonRaised.setMinimumSize(new Dimension(50, 25));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                value = "";
            }
            if (ButtonTableHeader.this._pressedColumnIdx == column && ButtonTableHeader.this._pressed) {
                this._buttonLowered.setText(value.toString());
                if (column == ButtonTableHeader.this._currentlySortedColumnIdx && ButtonTableHeader.this._currentSortedColumnIcon != null) {
                    this._buttonLowered.setIcon(ButtonTableHeader.this._currentSortedColumnIcon);
                } else {
                    this._buttonLowered.setIcon(null);
                }
                return this._buttonLowered;
            }
            this._buttonRaised.setText(value.toString());
            if (ButtonTableHeader.this._currentSortedColumnIcon != null && column == ButtonTableHeader.this._currentlySortedColumnIdx) {
                this._buttonRaised.setIcon(ButtonTableHeader.this._currentSortedColumnIcon);
            } else {
                this._buttonRaised.setIcon(null);
            }
            return this._buttonRaised;
        }
    }

    class HeaderListener
    extends MouseAdapter
    implements MouseMotionListener {
        HeaderListener() {
        }

        public void mousePressed(MouseEvent e) {
            ButtonTableHeader.this._pressed = true;
            ButtonTableHeader.this._pressedColumnIdx = ButtonTableHeader.this.columnAtPoint(e.getPoint());
            ButtonTableHeader.this.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            ButtonTableHeader.this._pressed = false;
            if (!ButtonTableHeader.this._dragged) {
                ButtonTableHeader.this._currentSortedColumnIcon = null;
                int column = ButtonTableHeader.this.getTable().convertColumnIndexToModel(ButtonTableHeader.this._pressedColumnIdx);
                TableModel tm = ButtonTableHeader.this.table.getModel();
                if (column > -1 && column < tm.getColumnCount() && tm instanceof SortableTableModel) {
                    ((SortableTableModel)tm).sortByColumn(column);
                    if (((SortableTableModel)tm)._bAscending) {
                        ButtonTableHeader.this._currentSortedColumnIcon = s_ascIcon;
                    } else {
                        ButtonTableHeader.this._currentSortedColumnIcon = s_descIcon;
                    }
                    ButtonTableHeader.this._currentlySortedColumnIdx = ButtonTableHeader.this._pressedColumnIdx;
                }
                ButtonTableHeader.this.repaint();
            }
            ButtonTableHeader.this._dragged = false;
        }

        public void mouseDragged(MouseEvent e) {
            ButtonTableHeader.this._dragged = true;
            if (ButtonTableHeader.this._pressed) {
                ButtonTableHeader.this._currentSortedColumnIcon = null;
                ButtonTableHeader.this._currentlySortedColumnIdx = -1;
                ButtonTableHeader.this._pressed = false;
                ButtonTableHeader.this.repaint();
            }
        }

        public void mouseMoved(MouseEvent e) {
            ButtonTableHeader.this._dragged = false;
        }
    }

    private final class TableDataListener
    implements TableModelListener {
        private TableDataListener() {
        }

        public void tableChanged(TableModelEvent evt) {
            ButtonTableHeader.this._currentSortedColumnIcon = null;
            ButtonTableHeader.this._currentlySortedColumnIdx = -1;
        }
    }
}

