/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;

public class DataTypeShort
implements IDataTypeComponent {
    private ColumnDisplayDefinition _colDef;
    private boolean _isNullable;
    private boolean _isSigned;
    private int _scale;
    private JTable _table;
    private IRestorableTextComponent _textComponent;
    private DefaultColumnRenderer _renderer = DefaultColumnRenderer.getInstance();

    public DataTypeShort(JTable table, ColumnDisplayDefinition colDef) {
        this._table = table;
        this._colDef = colDef;
        this._isNullable = colDef.isNullable();
        this._isSigned = colDef.isSigned();
        this._scale = colDef.getScale();
    }

    public String getClassName() {
        return "java.lang.Short";
    }

    public boolean areEqual(Object obj1, Object obj2) {
        return ((Short)obj1).equals(obj2);
    }

    public String renderObject(Object value) {
        return (String)this._renderer.renderObject(value);
    }

    public boolean isEditableInCell(Object originalValue) {
        return true;
    }

    public boolean needToReRead(Object originalValue) {
        return false;
    }

    public JTextField getJTextField() {
        this._textComponent = new RestorableJTextField();
        ((RestorableJTextField)this._textComponent).addKeyListener(new KeyTextHandler());
        ((RestorableJTextField)this._textComponent).addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent((RestorableJTextField)DataTypeShort.this._textComponent, evt, DataTypeShort.this._table);
                    CellDataPopup.showDialog(DataTypeShort.this._table, DataTypeShort.this._colDef, tableEvt, true);
                }
            }
        });
        return (JTextField)((Object)this._textComponent);
    }

    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        if (value.equals("<null>") || value.equals("")) {
            return null;
        }
        try {
            Short obj = new Short(value);
            return obj;
        }
        catch (Exception e) {
            messageBuffer.append(e.toString() + "\n");
            return null;
        }
    }

    public boolean useBinaryEditingPanel() {
        return false;
    }

    public boolean isEditableInPopup(Object originalValue) {
        return true;
    }

    public JTextArea getJTextArea(Object value) {
        this._textComponent = new RestorableJTextArea();
        ((RestorableJTextArea)this._textComponent).setText(this.renderObject(value));
        ((RestorableJTextArea)this._textComponent).addKeyListener(new KeyTextHandler());
        return (RestorableJTextArea)this._textComponent;
    }

    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    public Object readResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        short data = rs.getShort(index);
        if (rs.wasNull()) {
            return null;
        }
        return new Short(data);
    }

    public String getWhereClauseValue(Object value) {
        if (value == null || value.toString() == null || value.toString().length() == 0) {
            return this._colDef.getLabel() + " IS NULL";
        }
        return this._colDef.getLabel() + "=" + value.toString();
    }

    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null) {
            pstmt.setNull(position, this._colDef.getSqlType());
        } else {
            pstmt.setInt(position, ((Short)value).intValue());
        }
    }

    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            StringBuffer mbuf = new StringBuffer();
            Object newObject = this.validateAndConvert(dbDefaultValue, null, mbuf);
            if (mbuf.length() == 0) {
                return newObject;
            }
        }
        if (this._isNullable) {
            return null;
        }
        return new Short(0);
    }

    public boolean canDoFileIO() {
        return true;
    }

    public String importObject(FileInputStream inStream) throws IOException {
        InputStreamReader inReader = new InputStreamReader(inStream);
        int fileSize = inStream.available();
        char[] charBuf = new char[fileSize];
        int count = inReader.read(charBuf, 0, fileSize);
        if (count != fileSize) {
            throw new IOException("Could read only " + count + " chars from a total file size of " + fileSize + ". Import failed.");
        }
        String fileText = charBuf[count - 1] == '\n' ? new String(charBuf, 0, count - 1) : new String(charBuf);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(fileText, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException("Text does not represent data of type " + this.getClassName() + ".  Text was:\n" + fileText);
        }
        return fileText;
    }

    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        OutputStreamWriter outWriter = new OutputStreamWriter(outStream);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(text, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException(new String(messageBuffer));
        }
        outWriter.write(text);
        outWriter.flush();
        outWriter.close();
    }

    private class KeyTextHandler
    extends KeyAdapter {
        private KeyTextHandler() {
        }

        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            JTextComponent _theComponent = (JTextComponent)((Object)DataTypeShort.this._textComponent);
            String text = _theComponent.getText();
            if (!DataTypeShort.this._isSigned && c == '-') {
                _theComponent.getToolkit().beep();
                e.consume();
            }
            if (c == '\t' || c == '\n') {
                ((IRestorableTextComponent)((Object)_theComponent)).updateText(text.replaceAll("" + c, ""));
                _theComponent.getToolkit().beep();
                e.consume();
            }
            if (!Character.isDigit(c) && c != '-' && c != '\b' && c != '\u007f') {
                _theComponent.getToolkit().beep();
                e.consume();
            }
            if (DataTypeShort.this._scale > 0 && text.length() == DataTypeShort.this._scale && c != '\b' && c != '\u007f') {
                e.consume();
                _theComponent.getToolkit().beep();
            }
            if (DataTypeShort.this._isNullable) {
                if (text.equals("<null>")) {
                    if (c == '\b' || c == '\u007f') {
                        DataTypeShort.this._textComponent.restoreText();
                        e.consume();
                    } else {
                        DataTypeShort.this._textComponent.updateText("");
                    }
                } else if ((c == '\b' || c == '\u007f') && text.length() <= 1) {
                    DataTypeShort.this._textComponent.updateText("<null>");
                    e.consume();
                }
            } else if (text.length() == 0 && c == '\b' || c == '\u007f') {
                DataTypeShort.this._textComponent.restoreText();
                e.consume();
            }
        }
    }
}

