/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.sql.Blob;
import java.util.Arrays;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BinaryDisplayConverter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class BlobDescriptor {
    Blob _blob;
    byte[] _data = null;
    private boolean _blobRead = false;
    private boolean _wholeBlobRead = false;
    private int _userSetBlobLimit;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$BlobDescriptor == null ? (class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$BlobDescriptor = BlobDescriptor.class$("net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BlobDescriptor")) : class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$BlobDescriptor);
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$BlobDescriptor;

    public BlobDescriptor(Blob blob, byte[] data, boolean blobRead, boolean wholeBlobRead, int userSetBlobLimit) {
        this._blob = blob;
        this._data = data;
        this._blobRead = blobRead;
        this._wholeBlobRead = wholeBlobRead;
        this._userSetBlobLimit = userSetBlobLimit;
    }

    public boolean equals(BlobDescriptor c) {
        if (c == null) {
            return this._blobRead && this._data == null;
        }
        if (!c.getBlobRead()) {
            return !this._blobRead;
        }
        if (!this._blobRead) {
            return false;
        }
        return Arrays.equals(c.getData(), this._data);
    }

    public String toString() {
        if (this._blobRead) {
            if (this._data == null) {
                return null;
            }
            Byte[] useValue = new Byte[this._data.length];
            for (int i = 0; i < this._data.length; ++i) {
                useValue[i] = new Byte(this._data[i]);
            }
            String outString = BinaryDisplayConverter.convertToString(useValue, 16, false);
            if (this._wholeBlobRead || this._userSetBlobLimit > this._data.length) {
                return outString;
            }
            return outString + "...";
        }
        return s_stringMgr.getString("BlobDescriptor.blob");
    }

    public Blob getBlob() {
        return this._blob;
    }

    public void setBlob(Blob blob) {
        this._blob = blob;
    }

    public byte[] getData() {
        return this._data;
    }

    public void setData(byte[] data) {
        this._data = data;
    }

    public boolean getBlobRead() {
        return this._blobRead;
    }

    public void setBlobRead(boolean blobRead) {
        this._blobRead = blobRead;
    }

    public boolean getWholeBlobRead() {
        return this._wholeBlobRead;
    }

    public void setWholeBlobRead(boolean wholeBlobRead) {
        this._wholeBlobRead = wholeBlobRead;
    }

    public int getUserSetBlobLimit() {
        return this._userSetBlobLimit;
    }

    public void setUserSetBlobLimit(int userSetBlobLimit) {
        this._userSetBlobLimit = userSetBlobLimit;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

