/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class JavabeanDataSet
implements IDataSet {
    private ILogger s_log = LoggerController.createLogger(class$net$sourceforge$squirrel_sql$fw$datasetviewer$JavabeanDataSet == null ? (class$net$sourceforge$squirrel_sql$fw$datasetviewer$JavabeanDataSet = JavabeanDataSet.class$("net.sourceforge.squirrel_sql.fw.datasetviewer.JavabeanDataSet")) : class$net$sourceforge$squirrel_sql$fw$datasetviewer$JavabeanDataSet);
    private String _nameColumnName = "Property Name";
    private String _valueColumnName = "Value";
    private int _iCurrent = -1;
    private Object[] _currentRow;
    private List _data;
    private DataSetDefinition _dataSetDefinition;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$datasetviewer$JavabeanDataSet;

    public JavabeanDataSet() {
        this.commonCtor();
    }

    public JavabeanDataSet(Object bean) throws DataSetException {
        this.setJavabean(bean);
    }

    public void setJavabean(Object bean) throws DataSetException {
        this.commonCtor();
        if (bean != null) {
            try {
                BeanInfo info = Introspector.getBeanInfo(bean.getClass(), 1);
                this.processBeanInfo(bean, info);
            }
            catch (Exception ex) {
                throw new DataSetException(ex);
            }
        }
    }

    private void processBeanInfo(Object bean, BeanInfo info) throws InvocationTargetException, IllegalAccessException {
        BeanInfo[] extra = info.getAdditionalBeanInfo();
        if (extra != null) {
            for (int i = 0; i < extra.length; ++i) {
                this.processBeanInfo(bean, extra[i]);
            }
        }
        PropertyDescriptor[] propDesc = info.getPropertyDescriptors();
        for (int i = 0; i < propDesc.length; ++i) {
            Object[] line;
            String propName = propDesc[i].getName();
            Method getter = propDesc[i].getReadMethod();
            if (propName == null || getter == null) continue;
            String displayName = propDesc[i].getDisplayName();
            if (displayName == null) {
                displayName = propName;
            }
            if ((line = this.generateLine(displayName, bean, getter)) == null) continue;
            this._data.add(line);
        }
    }

    protected Object[] generateLine(String propTitle, Object bean, Method getter) throws InvocationTargetException, IllegalAccessException {
        Object[] line = new Object[]{propTitle, this.executeGetter(bean, getter)};
        return line;
    }

    protected Object executeGetter(Object bean, Method getter) throws InvocationTargetException, IllegalAccessException {
        return getter.invoke(bean, null);
    }

    public final int getColumnCount() {
        return 2;
    }

    public DataSetDefinition getDataSetDefinition() {
        return this._dataSetDefinition;
    }

    public synchronized boolean next(IMessageHandler msgHandler) throws DataSetException {
        if (++this._iCurrent < this._data.size()) {
            this._currentRow = (Object[])this._data.get(this._iCurrent);
            return true;
        }
        return false;
    }

    public Object get(int columnIndex) {
        return this._currentRow[columnIndex];
    }

    private ColumnDisplayDefinition[] createColumnDefinitions() {
        ColumnDisplayDefinition[] columnDefs = new ColumnDisplayDefinition[]{new ColumnDisplayDefinition(50, this._nameColumnName), new ColumnDisplayDefinition(50, this._valueColumnName)};
        return columnDefs;
    }

    private void commonCtor() {
        this._iCurrent = -1;
        this._data = new ArrayList();
        ColumnDisplayDefinition[] colDefs = this.createColumnDefinitions();
        this._dataSetDefinition = new DataSetDefinition(colDefs);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

