/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;

public class DatabaseTypesDataSet
implements IDataSet {
    private ResultSet _rs;
    private int[] _columnIndices;
    private int _columnCount;
    private DataSetDefinition _dataSetDefinition;
    private Object[] _row;

    public DatabaseTypesDataSet(ResultSet rs) throws DataSetException {
        this(rs, null);
    }

    public DatabaseTypesDataSet(ResultSet rs, int[] columnIndices) throws DataSetException {
        if (rs == null) {
            throw new IllegalArgumentException("Null ResultSet passed");
        }
        this._rs = rs;
        if (columnIndices != null && columnIndices.length == 0) {
            columnIndices = null;
        }
        this._columnIndices = columnIndices;
        try {
            ResultSetMetaData md = this._rs.getMetaData();
            this._columnCount = columnIndices != null ? columnIndices.length : md.getColumnCount();
            this._dataSetDefinition = new DataSetDefinition(this.createColumnDefinitions(md, columnIndices));
            this._row = new Object[this._columnCount];
        }
        catch (SQLException ex) {
            throw new DataSetException(ex);
        }
    }

    public final int getColumnCount() {
        return this._columnCount;
    }

    public DataSetDefinition getDataSetDefinition() {
        return this._dataSetDefinition;
    }

    public synchronized boolean next(IMessageHandler msgHandler) throws DataSetException {
        try {
            if (!this._rs.next()) {
                this._rs.close();
                return false;
            }
            block23: for (int i = 0; i < this._columnCount; ++i) {
                int idx = this._columnIndices != null ? this._columnIndices[i] : i + 1;
                try {
                    block2 : switch (idx) {
                        case 2: {
                            int data = this._rs.getInt(idx);
                            StringBuffer buf = new StringBuffer();
                            buf.append(String.valueOf(data)).append(" [").append(JDBCTypeMapper.getJdbcTypeName(data)).append("]");
                            this._row[i] = buf.toString();
                            break;
                        }
                        case 3: 
                        case 14: 
                        case 15: 
                        case 18: {
                            this._row[i] = this._rs.getObject(idx);
                            if (this._row[i] == null || this._row[i] instanceof Integer) continue block23;
                            if (this._row[i] instanceof Number) {
                                this._row[i] = new Integer(((Number)this._row[i]).intValue());
                                break;
                            }
                            this._row[i] = new Integer(this._row[i].toString());
                            break;
                        }
                        case 7: {
                            short nullable = this._rs.getShort(idx);
                            switch (nullable) {
                                case 0: {
                                    this._row[i] = "false";
                                    break block2;
                                }
                                case 1: {
                                    this._row[i] = "true";
                                    break block2;
                                }
                                case 2: {
                                    this._row[i] = "unknown";
                                    break block2;
                                }
                            }
                            this._row[i] = nullable + "[error]";
                            break;
                        }
                        case 8: 
                        case 10: 
                        case 11: 
                        case 12: {
                            this._row[i] = this._rs.getObject(idx);
                            if (this._row[i] == null || this._row[i] instanceof Boolean) continue block23;
                            if (this._row[i] instanceof Number) {
                                if (((Number)this._row[i]).intValue() == 0) {
                                    this._row[i] = Boolean.FALSE;
                                    break;
                                }
                                this._row[i] = Boolean.TRUE;
                                break;
                            }
                            this._row[i] = Boolean.valueOf(this._row[i].toString());
                            break;
                        }
                        case 9: {
                            short searchable = this._rs.getShort(idx);
                            switch (searchable) {
                                case 0: {
                                    this._row[i] = "no support";
                                    break block2;
                                }
                                case 1: {
                                    this._row[i] = "only supports 'WHERE...like'";
                                    break block2;
                                }
                                case 2: {
                                    this._row[i] = "supports all except 'WHERE...LIKE'";
                                    break block2;
                                }
                                case 3: {
                                    this._row[i] = "supports all WHERE";
                                    break block2;
                                }
                            }
                            this._row[i] = searchable + "[error]";
                            break;
                        }
                        case 16: 
                        case 17: {
                            break;
                        }
                        default: {
                            this._row[i] = this._rs.getString(idx);
                            break;
                        }
                    }
                    continue;
                }
                catch (Throwable th) {
                    if (msgHandler != null) {
                        this._row[i] = "<error>";
                        msgHandler.showMessage(th);
                        continue;
                    }
                    throw new DataSetException(th);
                }
            }
        }
        catch (SQLException ex) {
            if (msgHandler != null) {
                msgHandler.showMessage(ex);
            }
            throw new DataSetException(ex);
        }
        return true;
    }

    public Object get(int columnIndex) {
        return this._row[columnIndex];
    }

    private ColumnDisplayDefinition[] createColumnDefinitions(ResultSetMetaData md, int[] columnIndices) throws SQLException {
        ColumnDisplayDefinition[] columnDefs = new ColumnDisplayDefinition[this._columnCount];
        for (int i = 0; i < this._columnCount; ++i) {
            int idx = columnIndices != null ? columnIndices[i] : i + 1;
            columnDefs[i] = new ColumnDisplayDefinition(md.getColumnDisplaySize(idx), md.getColumnLabel(idx));
        }
        return columnDefs;
    }
}

