/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.hbm2java;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.hibernate.util.DTDEntityResolver;
import net.sourceforge.sqlexplorer.hbm2java.ClassMapping;
import net.sourceforge.sqlexplorer.hbm2java.Generator;
import net.sourceforge.sqlexplorer.hbm2java.MetaAttributeHelper;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class CodeGenerator {
    static final Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.sqlexplorer.hbm2java.CodeGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public static void main(String[] args) {
        try {
            ArrayList<String> mappingFiles = new ArrayList<String>();
            SAXBuilder builder = new SAXBuilder();
            builder.setEntityResolver((EntityResolver)new DTDEntityResolver());
            builder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException error) {
                    log.error((Object)("Error parsing XML: " + error.getSystemId() + '(' + error.getLineNumber() + ')'), (Throwable)error);
                }

                public void fatalError(SAXParseException error) {
                    this.error(error);
                }

                public void warning(SAXParseException error) {
                    log.warn((Object)("Warning parsing XML: " + error.getSystemId() + '(' + error.getLineNumber() + ')'));
                }
            });
            String outputDir = null;
            ArrayList<Generator> generators = new ArrayList<Generator>();
            MultiHashMap globalMetas = new MultiHashMap();
            int i = 0;
            while (i < args.length) {
                if (args[i].startsWith("--")) {
                    if (args[i].startsWith("--config=")) {
                        Document document = builder.build(new File(args[i].substring(9)));
                        globalMetas = MetaAttributeHelper.loadAndMergeMetaMap(document.getRootElement(), null);
                        Iterator generateElements = document.getRootElement().getChildren("generate").iterator();
                        while (generateElements.hasNext()) {
                            generators.add(new Generator((Element)generateElements.next()));
                        }
                    } else if (args[i].startsWith("--output=")) {
                        outputDir = args[i].substring(9);
                    }
                } else {
                    mappingFiles.add(args[i]);
                }
                ++i;
            }
            if (generators.size() == 0) {
                generators.add(new Generator());
            }
            HashMap<String, ClassMapping> classMappings = new HashMap<String, ClassMapping>();
            builder.setValidation(true);
            Iterator iter = mappingFiles.iterator();
            while (iter.hasNext()) {
                Document document = builder.build(new File((String)iter.next()));
                Element rootElement = document.getRootElement();
                Iterator classElements = rootElement.getChildren("class").iterator();
                MultiMap mm = MetaAttributeHelper.loadAndMergeMetaMap(rootElement, (MultiMap)globalMetas);
                while (classElements.hasNext()) {
                    ClassMapping cmap = new ClassMapping((Element)classElements.next(), mm);
                    classMappings.put(cmap.getCanonicalName(), cmap);
                }
            }
            Iterator iterator = generators.iterator();
            while (iterator.hasNext()) {
                Generator g = (Generator)iterator.next();
                g.setBaseDirName(outputDir);
                g.generate(classMappings);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

