/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.hbm2java;

public class ClassName {
    private String fullyQualifiedName = null;
    private String packageName = null;
    private String name = null;
    private boolean primitive = false;
    private boolean isArray = false;

    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.setFullyQualifiedName(fullyQualifiedName, false);
    }

    public void setFullyQualifiedName(String fullyQualifiedName, boolean isPrimitive) {
        this.fullyQualifiedName = fullyQualifiedName;
        this.primitive = isPrimitive;
        if (!isPrimitive) {
            if (fullyQualifiedName != null) {
                int lastDot = fullyQualifiedName.lastIndexOf(".");
                if (lastDot < 0) {
                    this.name = fullyQualifiedName;
                    this.packageName = null;
                } else {
                    this.name = fullyQualifiedName.substring(lastDot + 1);
                    this.packageName = fullyQualifiedName.substring(0, lastDot);
                }
            } else {
                this.name = fullyQualifiedName;
                this.packageName = null;
            }
        } else {
            this.name = fullyQualifiedName;
            this.packageName = null;
        }
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public boolean inJavaLang() {
        return "java.lang".equals(this.packageName);
    }

    public boolean inSamePackage(ClassName other) {
        return other.packageName == this.packageName || other.packageName != null && other.packageName.equals(this.packageName);
    }

    public boolean equals(Object other) {
        ClassName otherClassName = (ClassName)other;
        return otherClassName.fullyQualifiedName.equals(this.fullyQualifiedName);
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public void setIsArray(boolean b) {
        this.isArray = b;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }
}

