/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.hbexport.actions;

import java.io.File;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbviewer.model.CatalogNode;
import net.sourceforge.sqlexplorer.dbviewer.model.SchemaNode;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.dbviewer.model.TableObjectTypeNode;
import net.sourceforge.sqlexplorer.ext.hbexport.MapGenerator;
import net.sourceforge.sqlexplorer.ext.hbexport.dialogs.ExportDialog;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;

public class ExportWizard
extends Action {
    SessionTreeNode sessionNode;
    TableNode node;

    public ExportWizard(SessionTreeNode sessionNode, TableNode node) {
        this.sessionNode = sessionNode;
        this.node = node;
    }

    public String getText() {
        return "Export through Hibernate...";
    }

    public void run() {
        ExportDialog ed = new ExportDialog(null, this.sessionNode, this.node);
        if (ed.open() == 0) {
            CatalogNode cn;
            String cn_name;
            String pkgName = ExportDialog.pkgName;
            String generator = ExportDialog.generator;
            String idType = ExportDialog.idType;
            String dir = ExportDialog.outDirText;
            boolean hibernateType = ExportDialog.hibernateTypeSelected;
            MapGenerator mg = new MapGenerator();
            TableObjectTypeNode totn = (TableObjectTypeNode)this.node.getParent();
            if (totn.getParent() instanceof SchemaNode) {
                mg.setSchemaPattern(totn.getParent().toString());
            } else if (totn.getParent() instanceof CatalogNode && (cn_name = (cn = (CatalogNode)totn.getParent()).toString()) != Messages.getString((String)"NoCatalog_2")) {
                mg.setCatalog(cn.toString());
            }
            try {
                mg.setTableNames(new String[]{this.node.toString()});
                mg.setPackageName(pkgName);
                mg.setGenerator(generator);
                mg.setIdType(idType);
                mg.setOutputDirectory(new File(dir));
                mg.setHibernateTypes(hibernateType);
                mg.generate(this.sessionNode.getConnection().getConnection());
            }
            catch (Exception e) {
                SQLExplorerPlugin.error((String)"Hibernate Export Error", (Throwable)e);
                MessageDialog.openError(null, (String)"Error", (String)e.getMessage());
            }
        }
    }
}

