/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.hbexport;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.sqlexplorer.ddl2hbm.JDBCUtil;
import net.sourceforge.sqlexplorer.hbm2java.ClassMapping;
import net.sourceforge.sqlexplorer.hbm2java.ClassName;
import net.sourceforge.sqlexplorer.hbm2java.Generator;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.input.DOMBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapGenerator {
    private static Log logger;
    private String generator;
    private String[] generatorParameters;
    private String packageName;
    private String catalog;
    private String schemaPattern;
    private String idType;
    private String[] tableTypes = new String[]{"TABLE", "VIEW", "SYNONYM", "ALIAS"};
    private File outputDirectory;
    private String idName;
    private DocumentBuilder docBuilder;
    private TransformerFactory tFactory;
    private boolean generateSource = true;
    private String baseClass;
    private DOMBuilder jdomBuilder;
    private boolean singleMapFile;
    private String[] tableNames;
    private String mappingFile;
    private boolean hibernateTypes;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.sqlexplorer.ext.hbexport.MapGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public MapGenerator() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            this.docBuilder = dbf.newDocumentBuilder();
            this.tFactory = TransformerFactory.newInstance();
            this.jdomBuilder = new DOMBuilder();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void generate(Connection c) throws IOException, SQLException, Exception {
        Document d = this.getMap(c);
        this.writeMapping(d);
        this.generateCode(d);
    }

    public Document getMap(Connection c) throws IOException, SQLException {
        Document hbm = this.createMappingDoc();
        logger.debug((Object)"reading tables from database");
        String[] tableNames = this.getTableNames();
        int i = 0;
        while (tableNames != null && i < tableNames.length) {
            this.addHibernateClass(c, tableNames[i], hbm.getDocumentElement());
            ++i;
        }
        logger.debug((Object)"done reading tables from database");
        return hbm;
    }

    public void generateCode(Document doc) throws Exception {
        HashMap<String, ClassMapping> map = new HashMap<String, ClassMapping>();
        NodeList classes = doc.getElementsByTagName("class");
        if (classes == null || classes.getLength() == 0) {
            return;
        }
        int i = 0;
        while (i < classes.getLength()) {
            Element classElement = (Element)classes.item(i);
            ClassMapping cmap = null;
            if (this.getBaseClass() != null) {
                ClassName cName = new ClassName();
                cName.setFullyQualifiedName(this.getBaseClass());
                cmap = new ClassMapping(cName, this.jdomBuilder.build(classElement), (MultiMap)new MultiHashMap());
            } else {
                cmap = new ClassMapping(this.jdomBuilder.build(classElement), (MultiMap)new MultiHashMap());
            }
            map.put(cmap.getCanonicalName(), cmap);
            ++i;
        }
        Generator g = new Generator();
        g.setBaseDirName(this.getOutputDirectory().getAbsolutePath());
        g.generate(map);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeMapping(Document mapping) throws IOException {
        String pkgName = String.valueOf(this.packageName.replace('.', File.separatorChar)) + File.separatorChar;
        File packageDir = new File(this.outputDirectory, pkgName);
        if (!packageDir.exists()) {
            packageDir.mkdirs();
        }
        if (this.isSingleMapFile()) {
            File mappingFile = new File(packageDir, this.getMappingFile());
            FileOutputStream fos = new FileOutputStream(mappingFile);
            try {
                logger.debug((Object)("writing to file " + mappingFile));
                this.writeHbm(mapping, fos);
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                fos.close();
                throw throwable;
            }
            {
                Object var6_11 = null;
                fos.close();
                return;
            }
        }
        NodeList classes = mapping.getElementsByTagName("class");
        int i = 0;
        while (i < classes.getLength()) {
            Object var11_16;
            Element classElement = (Element)classes.item(i);
            Document hibDoc = this.createMappingDoc();
            classElement = (Element)hibDoc.importNode(classElement, true);
            hibDoc.getDocumentElement().appendChild(classElement);
            String fname = String.valueOf(this.makeEntityName(classElement.getAttribute("table"))) + ".hbm.xml";
            File mappingFile = new File(packageDir, fname);
            logger.debug((Object)("writing to file " + mappingFile));
            FileOutputStream fos = new FileOutputStream(mappingFile);
            try {
                this.writeHbm(hibDoc, fos);
            }
            catch (Throwable throwable) {
                var11_16 = null;
                fos.close();
                throw throwable;
            }
            {
                var11_16 = null;
            }
            fos.close();
            ++i;
        }
        return;
    }

    protected void writeHbm(Node node, OutputStream os) {
        try {
            Transformer transformer = this.tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("doctype-system", "http://hibernate.sourceforge.net/hibernate-mapping-2.0.dtd");
            transformer.setOutputProperty("doctype-public", "-//Hibernate/Hibernate Mapping DTD 2.0//EN");
            DOMSource source = new DOMSource(node);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException tce) {
            logger.error((Object)"Transformation configuration error", (Throwable)tce);
            throw new RuntimeException(tce.getMessage());
        }
        catch (TransformerException te) {
            logger.error((Object)"Transformation error", (Throwable)te);
            throw new RuntimeException(te.getMessage());
        }
    }

    protected String getXml(Node node) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeNode(node, baos);
            baos.close();
            return baos.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
    }

    protected void writeNode(Node node, OutputStream os) {
        try {
            Transformer transformer = this.tFactory.newTransformer();
            DOMSource source = new DOMSource(node);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException tce) {
            logger.error((Object)"Transformation configuration error", (Throwable)tce);
            throw new RuntimeException(tce.getMessage());
        }
        catch (TransformerException te) {
            logger.error((Object)"Transformation error", (Throwable)te);
            throw new RuntimeException(te.getMessage());
        }
    }

    protected Document createMappingDoc() {
        Document hbm = this.docBuilder.newDocument();
        Element hibernate = hbm.createElement("hibernate-mapping");
        hbm.appendChild(hibernate);
        return hbm;
    }

    protected void addHibernateClass(Connection c, String tableName, Element mappingElement) throws SQLException {
        logger.debug((Object)("adding hibernate class for table " + tableName));
        Document hbm = mappingElement.getOwnerDocument();
        Element classElement = hbm.createElement("class");
        String className = String.valueOf(this.getPackageName()) + "." + this.makeEntityName(tableName);
        classElement.setAttribute("name", className);
        classElement.setAttribute("table", tableName);
        if (this.getSchemaPattern() != null) {
            classElement.setAttribute("schema", this.getSchemaPattern());
        }
        List pkColumns = JDBCUtil.getPrimaryKeyColumns(c, this.getCatalog(), this.getSchemaPattern(), tableName);
        Set fkColumns = JDBCUtil.getForeignKeyColumns(c, this.getCatalog(), this.getSchemaPattern(), tableName);
        List columns = JDBCUtil.getTableColumns(c, this.getCatalog(), this.getSchemaPattern(), tableName);
        if (pkColumns.size() == 1) {
            this.addId(classElement, (JDBCUtil.Column)pkColumns.iterator().next());
        } else if (pkColumns.size() > 1) {
            this.addCompositeId(classElement, pkColumns, fkColumns);
        }
        this.addProperties(classElement, pkColumns, fkColumns, columns);
        logger.debug((Object)("class element: " + this.getXml(classElement)));
        mappingElement.appendChild(classElement);
    }

    protected void addId(Element classElement, JDBCUtil.Column pkColumn) {
        Document hbm = classElement.getOwnerDocument();
        Element identifierElement = hbm.createElement("id");
        String idName = this.getIdName();
        if (idName == null) {
            idName = this.makeMemberName(pkColumn.name);
        }
        identifierElement.setAttribute("name", idName);
        identifierElement.setAttribute("column", pkColumn.name);
        if (this.getIdType() != null) {
            identifierElement.setAttribute("type", this.getIdType());
        } else {
            String type = this.isHibernateTypes() ? pkColumn.hibernateType.getName() : pkColumn.javaType.getName();
            identifierElement.setAttribute("type", type);
            if (pkColumn.sqlColumnLength > 0) {
                identifierElement.setAttribute("length", "" + pkColumn.sqlColumnLength);
            }
        }
        this.addGenerator(identifierElement);
        classElement.appendChild(identifierElement);
    }

    protected void addCompositeId(Element classElement, Collection primaryKeys, Collection foreignKeys) {
        Document hbm = classElement.getOwnerDocument();
        Element identifierElement = hbm.createElement("composite-id");
        Iterator it = primaryKeys.iterator();
        while (it.hasNext()) {
            JDBCUtil.Column pkColumn = (JDBCUtil.Column)it.next();
            Element property = hbm.createElement("key-property");
            property.setAttribute("name", this.makeMemberName(pkColumn.name));
            if (this.getIdType() != null && foreignKeys.contains(pkColumn)) {
                property.setAttribute("type", this.getIdType());
            } else {
                property.setAttribute("column", pkColumn.name);
                String type = this.isHibernateTypes() ? pkColumn.hibernateType.getName() : pkColumn.javaType.getName();
                property.setAttribute("type", type);
                if (pkColumn.sqlColumnLength > 0) {
                    property.setAttribute("length", "" + pkColumn.sqlColumnLength);
                }
            }
            identifierElement.appendChild(property);
        }
        classElement.appendChild(identifierElement);
    }

    protected void addProperties(Element classElement, Collection pkColumns, Collection fkColumns, Collection columns) {
        Document hbm = classElement.getOwnerDocument();
        Iterator it = columns.iterator();
        while (it.hasNext()) {
            JDBCUtil.Column column = (JDBCUtil.Column)it.next();
            if (pkColumns.contains(column)) continue;
            Element propertyElement = hbm.createElement("property");
            propertyElement.setAttribute("name", this.makeMemberName(column.name));
            propertyElement.setAttribute("column", column.name);
            if (this.getIdType() != null && fkColumns.contains(column)) {
                propertyElement.setAttribute("type", this.getIdType());
            } else {
                String type = this.isHibernateTypes() ? column.hibernateType.getName() : column.javaType.getName();
                propertyElement.setAttribute("type", type);
                if (column.sqlColumnLength > 0) {
                    propertyElement.setAttribute("length", "" + column.sqlColumnLength);
                }
            }
            if (column.sqlNotNull) {
                propertyElement.setAttribute("not-null", "" + column.sqlNotNull);
            }
            logger.debug((Object)("column info: " + this.getXml(propertyElement)));
            classElement.appendChild(propertyElement);
        }
    }

    protected void addGenerator(Element idElement) {
        Document hbm = idElement.getOwnerDocument();
        Element generator = hbm.createElement("generator");
        generator.setAttribute("class", this.getGenerator());
        if (this.generatorParameters != null) {
            int i = 0;
            while (i < this.generatorParameters.length) {
                Element param = hbm.createElement("param");
                param.appendChild(hbm.createTextNode(this.generatorParameters[i]));
                generator.appendChild(param);
                ++i;
            }
        }
        idElement.appendChild(generator);
    }

    protected String makeEntityName(String name) {
        String tmp = this.makeMemberName(name);
        tmp = String.valueOf(tmp.substring(0, 1).toUpperCase()) + tmp.substring(1);
        return tmp;
    }

    protected String makeMemberName(String name) {
        int i;
        String memberName = name.toLowerCase();
        while ((i = memberName.indexOf(95)) != -1) {
            String tmp1 = memberName.substring(0, i);
            if (i + 1 < memberName.length()) {
                tmp1 = String.valueOf(tmp1) + memberName.substring(i + 1, i + 2).toUpperCase();
            }
            if (i + 2 < memberName.length()) {
                tmp1 = String.valueOf(tmp1) + memberName.substring(i + 2);
            }
            memberName = tmp1;
        }
        return memberName;
    }

    public String getSchemaPattern() {
        return this.schemaPattern;
    }

    public void setSchemaPattern(String schemaPattern) {
        this.schemaPattern = schemaPattern;
    }

    public String[] getTableNames() {
        return this.tableNames;
    }

    public void setTableNames(String[] tableNames) {
        this.tableNames = tableNames;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String[] getTableTypes() {
        return this.tableTypes;
    }

    public void setTableTypes(String[] tableTypes) {
        this.tableTypes = tableTypes;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
        if (!outputDirectory.exists() || !outputDirectory.isDirectory()) {
            throw new RuntimeException("Invalid directory " + outputDirectory);
        }
    }

    public String getIdName() {
        return this.idName;
    }

    public void setIdName(String idName) {
        this.idName = idName;
    }

    public String getGenerator() {
        return this.generator;
    }

    public void setGenerator(String generator) {
        this.generator = generator;
    }

    public String[] getGeneratorParameters() {
        return this.generatorParameters;
    }

    public void setGeneratorParameters(String[] generatorParameters) {
        this.generatorParameters = generatorParameters;
    }

    public String getMappingFile() {
        return this.mappingFile;
    }

    public void setMappingFile(String mappingFile) {
        this.mappingFile = mappingFile;
    }

    public String getIdType() {
        return this.idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public String getBaseClass() {
        return this.baseClass;
    }

    public void setBaseClass(String baseClass) {
        this.baseClass = baseClass;
    }

    public boolean isGenerateSource() {
        return this.generateSource;
    }

    public void setGenerateSource(boolean generateSource) {
        this.generateSource = generateSource;
    }

    public boolean isSingleMapFile() {
        return this.singleMapFile;
    }

    public void setSingleMapFile(boolean singleMapFile) {
        this.singleMapFile = singleMapFile;
    }

    public boolean isHibernateTypes() {
        return this.hibernateTypes;
    }

    public void setHibernateTypes(boolean hibernateTypes) {
        this.hibernateTypes = hibernateTypes;
    }
}

