/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadclipse.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class StringChoiceFieldEditor
extends FieldEditor {
    private Combo fCombo;
    private List fKeys = new ArrayList(5);
    private List fLabels = new ArrayList(5);
    private String fOldKey;
    private boolean fIsValid;

    public StringChoiceFieldEditor(String name, String label, Composite parent) {
        super(name, label, parent);
        this.initList();
    }

    public void addItem(String key, String label) {
        this.fKeys.add(key);
        this.fLabels.add(label);
        this.fCombo.add(label);
    }

    protected void adjustForNumColumns(int numColumns) {
        if (this.fCombo != null) {
            GridData gd = (GridData)this.fCombo.getLayoutData();
            gd.horizontalSpan = numColumns - 1;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label l = new Label(parent, 0);
        l.setText(this.getLabelText());
        GridData gd = new GridData();
        this.fCombo = new Combo(parent, 8);
        this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringChoiceFieldEditor.this.valueChanged();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = numColumns - 1;
        this.fCombo.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        String value = this.getPreferenceStore().getString(this.getPreferenceName());
        int index = this.fCombo.indexOf(value);
        if (index >= 0) {
            this.fCombo.select(index);
        }
    }

    protected void doLoadDefault() {
        String value = this.getPreferenceStore().getString(this.getPreferenceName());
        int index = this.fCombo.indexOf(value);
        if (index >= 0) {
            this.fCombo.select(index);
        }
    }

    protected void doStore() {
        String value = "";
        if (this.fCombo.getSelectionIndex() >= 0) {
            value = this.fCombo.getItem(this.fCombo.getSelectionIndex());
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), value);
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected String getSelectedKey() {
        int index = this.fCombo.getSelectionIndex();
        if (index >= 0) {
            return (String)this.fKeys.get(index);
        }
        return null;
    }

    protected void initList() {
        int i = 0;
        while (i < this.fLabels.size()) {
            this.fCombo.add((String)this.fLabels.get(i));
            ++i;
        }
        this.fOldKey = this.getSelectedKey();
    }

    public boolean isValid() {
        return this.fIsValid;
    }

    protected void refreshValidState() {
        this.fIsValid = this.fCombo.getSelectionIndex() >= 0;
    }

    public void removeItem(String key) {
        int index = this.fKeys.indexOf(key);
        if (index >= 0) {
            this.fKeys.remove(index);
            String label = (String)this.fLabels.get(index);
            this.fLabels.remove(index);
            this.fCombo.remove(label);
        }
    }

    public void setFocus() {
        if (this.fCombo != null) {
            this.fCombo.setFocus();
        }
    }

    protected void valueChanged() {
        String newKey;
        this.setPresentsDefaultValue(false);
        boolean oldState = this.fIsValid;
        this.refreshValidState();
        if (this.fIsValid != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this.fIsValid);
        }
        if ((newKey = this.getSelectedKey()) == null ? newKey != this.fOldKey : !newKey.equals(this.fOldKey)) {
            this.fireValueChanged("field_editor_value", this.fOldKey, newKey);
            this.fOldKey = newKey;
        }
    }
}

