/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadclipse;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.jadclipse.IDecompiler;
import net.sf.jadclipse.JadDecompiler;
import net.sf.jadclipse.JadclipsePlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.SourceRange;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class JadclipseSourceMapper
extends SourceMapper {
    private IDecompiler decompiler = new JadDecompiler();
    private SourceMapper originalSourceMapper;
    private boolean isAttachedSource;

    public JadclipseSourceMapper() {
        super((IPath)new Path("."), "", new HashMap());
    }

    public char[] findSource(IType type) {
        if (!type.isBinary()) {
            return null;
        }
        BinaryType parent = (BinaryType)type.getDeclaringType();
        BinaryType declType = (BinaryType)type;
        while (parent != null) {
            declType = parent;
            parent = (BinaryType)declType.getDeclaringType();
        }
        IBinaryType info = null;
        try {
            info = (IBinaryType)declType.getElementInfo();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        if (info == null) {
            return null;
        }
        return this.findSource(type, info);
    }

    public char[] findSource(IType type, IBinaryType info) {
        char[] attachedSource;
        IPreferenceStore prefs = JadclipsePlugin.getDefault().getPreferenceStore();
        boolean always = prefs.getBoolean("net.sf.jadclipse.alwaysuse");
        if (this.originalSourceMapper != null && !always && (attachedSource = this.originalSourceMapper.findSource(type, info)) != null) {
            this.isAttachedSource = true;
            return attachedSource;
        }
        if (info == null) {
            return null;
        }
        LinkedList<JavaModelException> exceptions = new LinkedList<JavaModelException>();
        IPackageFragment pkgFrag = type.getPackageFragment();
        IPackageFragmentRoot root = (IPackageFragmentRoot)pkgFrag.getParent();
        try {
            if (root instanceof PackageFragmentRoot) {
                char[] attachedSource2;
                PackageFragmentRoot pfr = (PackageFragmentRoot)root;
                SourceMapper sourceMapper = pfr.getSourceMapper();
                if (sourceMapper != null && !always && !(sourceMapper instanceof JadclipseSourceMapper) && (attachedSource2 = sourceMapper.findSource(type, info)) != null) {
                    this.isAttachedSource = true;
                    return attachedSource2;
                }
                if (this.originalSourceMapper == null) {
                    this.originalSourceMapper = sourceMapper;
                    pfr.setSourceMapper((SourceMapper)this);
                }
            }
        }
        catch (JavaModelException e) {
            JadclipsePlugin.logError(e, "Could not set source mapper.");
        }
        this.isAttachedSource = false;
        String pkg = type.getPackageFragment().getElementName().replace('.', '/');
        String location = "\tDecompiled from: ";
        String classFile = new String(info.getFileName());
        int p = classFile.lastIndexOf(47);
        classFile = classFile.substring(p + 1);
        if (root.isArchive()) {
            String archivePath = this.getArchivePath(root);
            location = String.valueOf(location) + archivePath;
            this.decompiler.decompileFromArchive(archivePath, pkg, classFile);
        } else {
            try {
                location = String.valueOf(location) + root.getUnderlyingResource().getLocation().toOSString() + "/" + pkg + "/" + classFile;
                this.decompiler.decompile(root.getUnderlyingResource().getLocation().toOSString(), pkg, classFile);
            }
            catch (JavaModelException e) {
                exceptions.add(e);
            }
        }
        StringBuffer source = new StringBuffer();
        source.append(this.formatSource(this.decompiler.getSource()));
        source.append("\n\n/*");
        source.append("\n\tDECOMPILATION REPORT\n\n");
        source.append(location).append("\n");
        source.append("\tTotal time: ").append(this.decompiler.getDecompilationTime()).append(" ms\n");
        source.append(this.decompiler.getLog());
        exceptions.addAll(this.decompiler.getExceptions());
        this.logExceptions(exceptions, source);
        source.append("\n*/");
        return source.toString().toCharArray();
    }

    private String formatSource(String source) {
        String result = null;
        IPreferenceStore prefs = JadclipsePlugin.getDefault().getPreferenceStore();
        boolean useFormatter = prefs.getBoolean("net.sf.jadclipse.use_eclipse_formatter");
        if (source != null && useFormatter) {
            CodeFormatter formatter = ToolFactory.createCodeFormatter(null);
            TextEdit textEdit = formatter.format(8, source, 0, source.length(), 0, null);
            if (textEdit != null) {
                Document document = new Document(source);
                try {
                    textEdit.apply((IDocument)document);
                }
                catch (BadLocationException e) {
                    JadclipsePlugin.logError(e, "Unable to apply text formatting.");
                }
                result = document.get();
            }
            if (result == null) {
                JadclipsePlugin.logError(null, "Could not format code, it will remain unformatted.");
                result = source;
            }
        } else {
            result = source;
        }
        return result;
    }

    private void logExceptions(Collection exceptions, StringBuffer buffer) {
        buffer.append("\tCaught exceptions:");
        if (exceptions == null || exceptions.size() == 0) {
            return;
        }
        buffer.append("\n");
        StringWriter stackTraces = new StringWriter();
        PrintWriter stackTracesP = new PrintWriter(stackTraces);
        Iterator i = exceptions.iterator();
        while (i.hasNext()) {
            ((Exception)i.next()).printStackTrace(stackTracesP);
            stackTracesP.println("");
        }
        stackTracesP.flush();
        stackTracesP.close();
        buffer.append(stackTraces.toString());
    }

    private String getArchivePath(IPackageFragmentRoot root) {
        String archivePath = null;
        try {
            IResource resource = root.getUnderlyingResource();
            archivePath = resource != null ? resource.getLocation().toOSString() : root.getPath().toOSString();
        }
        catch (JavaModelException e) {
            throw new RuntimeException("Unexpected Java model exception: " + e.toString());
        }
        return archivePath;
    }

    protected IJavaElement findElement(IJavaElement elt, int position) {
        SourceRange range = this.getSourceRange(elt);
        if (range == null || position < range.getOffset() || range.getOffset() + range.getLength() - 1 < position) {
            return null;
        }
        if (elt instanceof IParent) {
            try {
                IJavaElement[] children = ((IParent)elt).getChildren();
                int i = 0;
                while (i < children.length) {
                    IJavaElement match = this.findElement(children[i], position);
                    if (match != null) {
                        return match;
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return elt;
    }

    public void mapSource(IType type, char[] contents, boolean force) {
        if (force) {
            this.sourceRanges.remove(type);
        }
        super.mapSource(type, contents, null);
    }

    public boolean isAttachedSource() {
        return this.isAttachedSource;
    }
}

