/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadclipse;

import net.sf.jadclipse.JadclipseBufferManager;
import net.sf.jadclipse.JadclipsePlugin;
import net.sf.jadclipse.JadclipseSourceMapper;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileEditor;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorInput;

public class JadclipseClassFileEditor
extends ClassFileEditor {
    public static final String ID = "net.sf.jadclipse.JadclipseClassFileEditor";
    public static final String MARK = "/*jadclipse*/";
    private static final char[] MARK_ARRAY = "/*jadclipse*/".toCharArray();
    private JadclipseSourceMapper sourceMapper;

    protected JadclipseBufferManager getBufferManager() {
        BufferManager defManager = BufferManager.getDefaultBufferManager();
        JadclipseBufferManager manager = defManager instanceof JadclipseBufferManager ? (JadclipseBufferManager)defManager : new JadclipseBufferManager(defManager);
        return manager;
    }

    public void doSetInput(boolean force) {
        IEditorInput input = this.getEditorInput();
        if (this.doOpenBuffer(input, force)) {
            try {
                this.doSetInput(input);
            }
            catch (Exception e) {
                JadclipsePlugin.logError(e, "");
            }
        }
    }

    public boolean containsDecompiled() {
        return this.sourceMapper != null;
    }

    private boolean doOpenBuffer(IEditorInput input, boolean force) {
        if (input instanceof IClassFileEditorInput) {
            try {
                boolean opened = false;
                IClassFile cf = ((IClassFileEditorInput)input).getClassFile();
                IPreferenceStore prefs = JadclipsePlugin.getDefault().getPreferenceStore();
                boolean reuseBuf = prefs.getBoolean("net.sf.jadclipse.reusebuff");
                boolean always = prefs.getBoolean("net.sf.jadclipse.alwaysuse");
                String origSrc = cf.getSource();
                if (origSrc == null || always && !origSrc.startsWith(MARK) || origSrc.startsWith(MARK) && (!reuseBuf || force)) {
                    char[] src;
                    if (this.sourceMapper == null) {
                        this.sourceMapper = new JadclipseSourceMapper();
                    }
                    if ((src = this.sourceMapper.findSource(cf.getType())) == null) {
                        src = new char[]{'\n', '/', '/', 'E', 'r', 'r', 'o', 'r', '!'};
                    }
                    char[] markedSrc = null;
                    if (this.sourceMapper.isAttachedSource()) {
                        markedSrc = src;
                    } else {
                        markedSrc = new char[MARK_ARRAY.length + src.length];
                        System.arraycopy(MARK_ARRAY, 0, markedSrc, 0, MARK_ARRAY.length);
                        System.arraycopy(src, 0, markedSrc, MARK_ARRAY.length, src.length);
                    }
                    IBuffer buffer = BufferManager.createBuffer((IOpenable)cf);
                    buffer.setContents(markedSrc);
                    this.getBufferManager().addBuffer(buffer);
                    this.sourceMapper.mapSource(cf.getType(), markedSrc, true);
                    opened = true;
                }
                return opened;
            }
            catch (Exception e) {
                JadclipsePlugin.logError(e, "");
            }
        }
        return false;
    }
}

