/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadclipse;

import java.io.IOException;
import java.io.Writer;

public class DebugAlignWriter
extends Writer {
    private int curLine = 0;
    private StringBuffer lineContent = new StringBuffer();
    private Writer out;

    public DebugAlignWriter(Writer out) {
        super((Object)out);
        this.out = out;
    }

    public void close() throws IOException {
        if (this.lineContent.length() != 0) {
            this.out.write(this.lineContent.toString());
        }
        this.out.flush();
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    /*
     * Unable to fully structure code
     */
    public void write(char[] cbuf, int off, int len) throws IOException {
        i = off;
        while (i < off + len) {
            switch (cbuf[i]) {
                case '\n': {
                    aLine = this.cleanComment(this.lineContent.toString());
                    this.lineContent.setLength(0);
                    if (aLine.length() == 0) break;
                    align = this.getAlignTarget(aLine);
                    if (align == -1) ** GOTO lbl25
                    if (align < this.curLine) {
                        if (this.curLine != 0) {
                            this.out.write(10);
                        }
                        this.out.write("/* <-MISALIGNED-> */ ");
                        this.out.write(aLine);
                        ++this.curLine;
                        break;
                    }
                    if (align != this.curLine) ** GOTO lbl22
                    this.out.write(aLine);
                    break;
lbl-1000:
                    // 1 sources

                    {
                        this.out.write(10);
                        ++this.curLine;
lbl22:
                        // 2 sources

                        ** while (align > this.curLine)
                    }
lbl23:
                    // 1 sources

                    this.out.write(aLine);
                    break;
lbl25:
                    // 1 sources

                    if (this.curLine != 0) {
                        this.out.write(10);
                    }
                    ++this.curLine;
                    this.out.write(aLine);
                    break;
                }
                case '\r': {
                    break;
                }
                default: {
                    this.lineContent.append(cbuf[i]);
                }
            }
            ++i;
        }
    }

    int getAlignTarget(String line) {
        if (!line.startsWith("/*")) {
            return -1;
        }
        int end = line.indexOf("*/", 2);
        if (end == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(line.substring(2, end).trim());
        }
        catch (Exception exception) {
            return -1;
        }
    }

    String cleanComment(String line) {
        int comment = line.indexOf("//");
        if (comment == -1) {
            return line;
        }
        if (comment == 0 || line.trim().startsWith("//")) {
            return "";
        }
        return line.substring(0, comment);
    }
}

