/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadclipse;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jadclipse.CommandOption;
import net.sf.jadclipse.NumericOption;

public class CommandLine {
    private String command;
    private List options = new ArrayList();

    public CommandLine(String command, List options) {
        if (command == null || command.trim().length() == 0) {
            throw new IllegalArgumentException("bogus command");
        }
        this.command = command;
        if (options != null) {
            this.options.addAll(options);
        }
    }

    public String getCommand() {
        return this.command;
    }

    public List getOptions() {
        return this.options;
    }

    public CommandOption getOption(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        Iterator iter = this.options.iterator();
        while (iter.hasNext()) {
            CommandOption option = (CommandOption)iter.next();
            if (!name.equals(option.getName())) continue;
            return option;
        }
        return null;
    }

    public int getOptionCount() {
        return this.options.size();
    }

    public void addOption(CommandOption option) {
        this.options.add(option);
    }

    public void clearOptions() {
        this.options.clear();
    }

    private static int findTrailingNumber(String token) {
        int numIdx = -1;
        int i = token.length() - 1;
        while (i >= 0) {
            char ch = token.charAt(i);
            if (ch < '0' || ch > '9') break;
            numIdx = i--;
        }
        return numIdx;
    }

    private static NumericOption createNumericOption(String token, int numIdx) {
        String optName = token.substring(0, numIdx);
        int numValue = Integer.parseInt(token.substring(numIdx));
        return new NumericOption(optName, numValue);
    }

    private static NumericOption tryNumericOption(String token) throws ParseException {
        int numIdx = CommandLine.findTrailingNumber(token);
        if (numIdx == 0 || numIdx == 1) {
            throw new ParseException("option cannot start with a number", numIdx);
        }
        return numIdx > 0 ? CommandLine.createNumericOption(token, numIdx) : null;
    }

    public static CommandLine parse(String line, String optionPrefix) throws ParseException {
        if (line == null) {
            throw new IllegalArgumentException("null line");
        }
        if (optionPrefix == null) {
            throw new IllegalArgumentException("null option prefix");
        }
        int optStart = line.indexOf(optionPrefix);
        if (optStart == 0) {
            throw new ParseException("missing command", 0);
        }
        if (optStart < 0) {
            return new CommandLine(line.trim(), null);
        }
        String cmd = line.substring(0, optStart).trim();
        ArrayList<CommandOption> opts = new ArrayList<CommandOption>();
        StringTokenizer st = new StringTokenizer(line.substring(optStart), "\t ");
        String optName = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            boolean option = token.startsWith(optionPrefix);
            if (option) {
                NumericOption numOpt;
                if (optName != null) {
                    opts.add(new CommandOption(optName, null));
                    optName = null;
                }
                if ((numOpt = CommandLine.tryNumericOption(token)) != null) {
                    opts.add(numOpt);
                    continue;
                }
                optName = token;
                continue;
            }
            if (optName == null) {
                throw new ParseException("value without a name", 0);
            }
            opts.add(new CommandOption(optName, token));
            optName = null;
        }
        if (optName != null) {
            NumericOption numOpt = CommandLine.tryNumericOption(optName);
            if (numOpt != null) {
                opts.add(numOpt);
            } else {
                opts.add(new CommandOption(optName, null));
            }
        }
        return new CommandLine(cmd, opts);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.command).append(' ');
        Iterator iter = this.options.iterator();
        while (iter.hasNext()) {
            CommandOption option = (CommandOption)iter.next();
            buf.append(option.toString()).append(' ');
        }
        buf.setLength(buf.length() - 1);
        return buf.toString();
    }

    public static void main(String[] args) throws Exception {
        CommandLine cl = CommandLine.parse("C:\\Program Files\\jad -zxc ttt -x -lff100 -bb", "-");
        System.out.println("command: " + cl.getCommand());
        System.out.println("option count: " + cl.getOptionCount());
        List options = cl.getOptions();
        int i = 0;
        while (i < options.size()) {
            CommandOption opt = (CommandOption)options.get(i);
            System.out.println("option_" + i + "(" + opt.getClass().getName() + "): " + opt.toString());
            ++i;
        }
        System.out.println("-lff=" + cl.getOption("-lff").getValue());
        System.out.println(cl.toString());
    }
}

