/*
 * Decompiled with CFR 0.152.
 */
package net.sf.commonclipse.preferences;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.sf.commonclipse.CCMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddRemoveListFieldEditor
extends FieldEditor {
    private static final String DEFAULT_SEPARATOR = ";";
    private static final int VERTICAL_DIALOG_UNITS_PER_CHAR = 8;
    private static final int LIST_HEIGHT_IN_CHARS = 10;
    private static final int LIST_HEIGHT_IN_DLUS = 80;
    List list;
    private Composite top;
    private Text textField;
    private Button add;
    private Button remove;
    private String separator = ";";

    public AddRemoveListFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public AddRemoveListFieldEditor(String name, String labelText, String addButtonText, String removeButtonText, Composite parent) {
        super(name, labelText, parent);
        this.setAddButtonText(addButtonText);
        this.setRemoveButtonText(removeButtonText);
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.top.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.top = parent;
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        this.top.setLayoutData((Object)gd);
        Label label = this.getLabelControl(this.top);
        GridData labelData = new GridData();
        labelData.horizontalSpan = numColumns;
        label.setLayoutData((Object)labelData);
        this.list = new List(this.top, 2048);
        GridData listData = new GridData(768);
        listData.heightHint = this.convertVerticalDLUsToPixels((Control)this.list, 80);
        listData.horizontalSpan = numColumns;
        this.list.setLayoutData((Object)listData);
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddRemoveListFieldEditor.this.selectionChanged();
            }
        });
        Composite addRemoveGroup = new Composite(this.top, 0);
        GridData addRemoveData = new GridData(768);
        addRemoveData.horizontalSpan = numColumns;
        addRemoveGroup.setLayoutData((Object)addRemoveData);
        GridLayout addRemoveLayout = new GridLayout();
        addRemoveLayout.numColumns = numColumns;
        addRemoveLayout.marginHeight = 0;
        addRemoveLayout.marginWidth = 0;
        addRemoveGroup.setLayout((Layout)addRemoveLayout);
        Composite buttonGroup = new Composite(addRemoveGroup, 0);
        buttonGroup.setLayoutData((Object)new GridData());
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonGroup.setLayout((Layout)buttonLayout);
        this.add = new Button(buttonGroup, 0);
        this.add.setText(CCMessages.getString("preferences.button.add"));
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddRemoveListFieldEditor.this.add();
            }
        });
        GridData addData = new GridData(768);
        addData.heightHint = this.convertVerticalDLUsToPixels((Control)this.add, 14);
        addData.widthHint = this.convertHorizontalDLUsToPixels((Control)this.add, 61);
        this.add.setLayoutData((Object)addData);
        this.remove = new Button(buttonGroup, 0);
        this.remove.setEnabled(false);
        this.remove.setText(CCMessages.getString("preferences.button.remove"));
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddRemoveListFieldEditor.this.list.remove(AddRemoveListFieldEditor.this.list.getSelectionIndex());
                AddRemoveListFieldEditor.this.selectionChanged();
            }
        });
        GridData removeData = new GridData(768);
        removeData.heightHint = this.convertVerticalDLUsToPixels((Control)this.remove, 14);
        removeData.widthHint = this.convertHorizontalDLUsToPixels((Control)this.remove, 61);
        this.remove.setLayoutData((Object)removeData);
        this.textField = new Text(addRemoveGroup, 2048);
        GridData textData = new GridData(768);
        textData.horizontalSpan = numColumns - 1;
        textData.verticalAlignment = 1;
        this.textField.setLayoutData((Object)textData);
    }

    protected void doLoad() {
        String items = this.getPreferenceStore().getString(this.getPreferenceName());
        this.setList(items);
    }

    protected void doLoadDefault() {
        String items = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        this.setList(items);
    }

    private void setList(String items) {
        String[] itemArray = this.parseString(items);
        this.list.setItems(itemArray);
    }

    protected void doStore() {
        String s = this.createListString(this.list.getItems());
        if (s != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), s);
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    void add() {
        String tag = this.textField.getText();
        if (tag != null && tag.length() > 0) {
            if (!AddRemoveListFieldEditor.containsOnlyValidChars(tag)) {
                MessageDialog.openError((Shell)new Shell(), (String)CCMessages.getString("preferences.invalidfieldtitle"), (String)MessageFormat.format(CCMessages.getString("preferences.invalidfieldmessage"), tag));
                return;
            }
            this.list.add(tag);
        }
        this.textField.setText("");
    }

    public static boolean containsOnlyValidChars(String str) {
        char[] invalidChars = new char[]{'(', ')', '[', ']', '{', '}', '.', '/', '\\', '^', '$', '.', '&', '|', '+'};
        int strSize = str.length();
        int validSize = invalidChars.length;
        for (int i = 0; i < strSize; ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < validSize; ++j) {
                if (invalidChars[j] != ch) continue;
                return false;
            }
        }
        return true;
    }

    public void setAddButtonText(String text) {
        this.add.setText(text);
    }

    public void setRemoveButtonText(String text) {
        this.remove.setText(text);
    }

    public void setSeparator(String listSeparator) {
        this.separator = listSeparator;
    }

    private String createListString(String[] items) {
        StringBuffer path = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            path.append(items[i]);
            path.append(this.separator);
        }
        return path.toString();
    }

    private String[] parseString(String stringList) {
        StringTokenizer st = new StringTokenizer(stringList, this.separator);
        ArrayList<Object> v = new ArrayList<Object>();
        while (st.hasMoreElements()) {
            v.add(st.nextElement());
        }
        return v.toArray(new String[v.size()]);
    }

    void selectionChanged() {
        int index = this.list.getSelectionIndex();
        this.remove.setEnabled(index >= 0);
    }
}

