/*
 * Decompiled with CFR 0.152.
 */
package net.sf.commonclipse;

import java.util.Random;
import net.sf.commonclipse.CCPluginPreferences;
import net.sf.commonclipse.Generator;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public final class HashcodeGenerator
extends Generator {
    private static final String BUILDER_CLASS = "org.apache.commons.lang.builder.HashCodeBuilder";
    private static Generator instance = new HashcodeGenerator();
    private Random random = new Random();

    private HashcodeGenerator() {
    }

    public static Generator getInstance() {
        return instance;
    }

    protected String getMethodName() {
        return "hashCode";
    }

    protected String createMethod(IType type) throws JavaModelException {
        int initial = this.random.nextInt();
        int multiplier = this.random.nextInt();
        if (initial % 2 == 0) {
            ++initial;
        }
        if (multiplier % 2 == 0) {
            ++multiplier;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getJavadoc());
        buffer.append("public int hashCode()\n{\nreturn new HashCodeBuilder(");
        buffer.append(initial);
        buffer.append(", ");
        buffer.append(multiplier);
        buffer.append(")\n");
        if (CCPluginPreferences.getPreferences().appendSuperToHashcode()) {
            buffer.append(".appendSuper(super.hashCode())\n");
        }
        buffer.append(this.buildAppenderList(type));
        buffer.append(".toHashCode();\n}\n");
        return buffer.toString();
    }

    protected String getFieldAppender(String fieldName, String accessor) {
        return ".append(this." + fieldName + ")\n";
    }

    protected IMethod getExistingMethod(IType type) {
        return type.getMethod(this.getMethodName(), new String[0]);
    }

    protected void addImports(IType type) throws JavaModelException {
        type.getCompilationUnit().createImport(BUILDER_CLASS, null, null);
    }

    private String getJavadoc() {
        return "/**\n * @see java.lang.Object#hashCode()\n */\n";
    }
}

