/*
 * Decompiled with CFR 0.152.
 */
package net.sf.commonclipse;

import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.commonclipse.CCPlugin;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class CCPluginPreferences {
    private static CCPluginPreferences instance;
    private String toStringFQCN;
    private boolean toStringUseCustom;
    private String toStringClassAndConstant;
    private Pattern excludePattern;
    private IPropertyChangeListener preferenceListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("tostring_style")) {
                CCPluginPreferences.this.evaluateToStringStyle();
            } else if (event.getProperty().equals("exclude")) {
                CCPluginPreferences.this.evaluateExclusionList();
            }
        }
    };

    private CCPluginPreferences() {
        CCPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferenceListener);
        this.evaluateToStringStyle();
        this.evaluateExclusionList();
    }

    public static CCPluginPreferences getPreferences() {
        if (instance == null) {
            instance = new CCPluginPreferences();
        }
        return instance;
    }

    protected void evaluateToStringStyle() {
        String toStringfullStyle = CCPlugin.getDefault().getPreferenceStore().getString("tostring_style");
        if (toStringfullStyle == null || toStringfullStyle.equals("")) {
            this.toStringUseCustom = false;
            this.toStringFQCN = null;
            this.toStringClassAndConstant = null;
        } else {
            this.toStringUseCustom = true;
            int constantPos = toStringfullStyle.lastIndexOf(".");
            int classPos = toStringfullStyle.substring(0, constantPos).lastIndexOf(".") + 1;
            this.toStringFQCN = toStringfullStyle.substring(0, constantPos);
            this.toStringClassAndConstant = toStringfullStyle.substring(classPos, toStringfullStyle.length());
        }
    }

    public boolean appendSuperToHashcode() {
        return CCPlugin.getDefault().getPreferenceStore().getBoolean("hashcode_super");
    }

    public boolean appendSuperToToString() {
        return CCPlugin.getDefault().getPreferenceStore().getBoolean("tostring_super");
    }

    public boolean appendSuperToEquals() {
        return CCPlugin.getDefault().getPreferenceStore().getBoolean("equals_super");
    }

    public boolean appendSuperToCompareTo() {
        return CCPlugin.getDefault().getPreferenceStore().getBoolean("compareto_super");
    }

    public boolean addInstanceCheckToEquals() {
        return CCPlugin.getDefault().getPreferenceStore().getBoolean("equals_instancecheck");
    }

    public boolean useJavabeanToString() {
        return "bean".equals(CCPlugin.getDefault().getPreferenceStore().getString("tostring_bean"));
    }

    public boolean dontAskOnOverwrite() {
        return CCPlugin.getDefault().getPreferenceStore().getBoolean("dontask");
    }

    public boolean useFinalParameters() {
        return CCPlugin.getDefault().getPreferenceStore().getBoolean("final_param");
    }

    public Pattern getExcludedFielsPattern() {
        return this.excludePattern;
    }

    public boolean useCustomToStringStyle() {
        return this.toStringUseCustom;
    }

    public String getToStringStyleQualifiedClass() {
        return this.toStringFQCN;
    }

    public String getToStringStyleClassAndConstant() {
        return this.toStringClassAndConstant;
    }

    protected void evaluateExclusionList() {
        String excludedString = CCPlugin.getDefault().getPreferenceStore().getString("exclude");
        this.excludePattern = CCPluginPreferences.generateRegExp(excludedString);
    }

    public static Pattern generateRegExp(String stringList) {
        if (stringList == null || stringList.length() == 0) {
            return Pattern.compile("^[0]$");
        }
        StringTokenizer st = new StringTokenizer(stringList, ";");
        StringBuffer buffer = new StringBuffer();
        while (st.hasMoreElements()) {
            buffer.append("(^");
            buffer.append(st.nextToken().replace('?', '.'));
            buffer.append("$)");
            if (!st.hasMoreElements()) continue;
            buffer.append('|');
        }
        try {
            return Pattern.compile(buffer.toString());
        }
        catch (PatternSyntaxException e) {
            return Pattern.compile("^[0]$");
        }
    }
}

