/**
 * <copyright>
 *
 * Copyright (c) 2003-2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: SDOFactoryImpl.java,v 1.5 2005/06/08 06:24:25 nickb Exp $
 */
package org.eclipse.emf.ecore.sdo.impl;


import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.sdo.*;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class SDOFactoryImpl extends EFactoryImpl implements SDOFactory
{
  /**
   * Creates an instance of the factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public SDOFactoryImpl()
  {
    super();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EObject create(EClass eClass)
  {
    switch (eClass.getClassifierID())
    {
      case SDOPackage.ECHANGE_SUMMARY: return createEChangeSummary();
      case SDOPackage.ECHANGE_SUMMARY_SETTING: return createEChangeSummarySetting();
      case SDOPackage.EDATA_GRAPH: return createEDataGraph();
      case SDOPackage.EDATA_OBJECT: return createEDataObject();
      case SDOPackage.EPROPERTY: return createEProperty();
      case SDOPackage.ETYPE: return createEType();
      case SDOPackage.EDATA_OBJECT_ANY_TYPE: return createEDataObjectAnyType();
      case SDOPackage.EDATA_OBJECT_SIMPLE_ANY_TYPE: return createEDataObjectSimpleAnyType();
      default:
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Object createFromString(EDataType eDataType, String initialValue)
  {
    switch (eDataType.getClassifierID())
    {
      default:
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public String convertToString(EDataType eDataType, Object instanceValue)
  {
    switch (eDataType.getClassifierID())
    {
      default:
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EDataObject createEDataObject()
  {
    EDataObjectImpl eDataObject = new EDataObjectImpl();
    return eDataObject;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EDataGraph createEDataGraph()
  {
    EDataGraphImpl eDataGraph = new EDataGraphImpl();
    return eDataGraph;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EChangeSummary createEChangeSummary()
  {
    EChangeSummaryImpl eChangeSummary = new EChangeSummaryImpl();
    return eChangeSummary;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EProperty createEProperty()
  {
    EPropertyImpl eProperty = new EPropertyImpl();
    return eProperty;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EType createEType()
  {
    ETypeImpl eType = new ETypeImpl();
    return eType;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EDataObjectAnyType createEDataObjectAnyType()
  {
    EDataObjectAnyTypeImpl eDataObjectAnyType = new EDataObjectAnyTypeImpl();
    return eDataObjectAnyType;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EDataObjectSimpleAnyType createEDataObjectSimpleAnyType()
  {
    EDataObjectSimpleAnyTypeImpl eDataObjectSimpleAnyType = new EDataObjectSimpleAnyTypeImpl();
    return eDataObjectSimpleAnyType;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EChangeSummarySetting createEChangeSummarySetting()
  {
    EChangeSummarySettingImpl eChangeSummarySetting = new EChangeSummarySettingImpl();
    return eChangeSummarySetting;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public SDOPackage getSDOPackage()
  {
    return (SDOPackage)getEPackage();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @deprecated
   * @generated
   */
  public static SDOPackage getPackage()
  {
    return SDOPackage.eINSTANCE;
  }

  public EChangeSummarySetting createEChangeSummarySetting(EStructuralFeature eStructuralFeature, Object value, boolean isSet)
  {
    EChangeSummarySettingImpl eChangeSummarySetting = new EChangeSummarySettingImpl(eStructuralFeature, value, isSet);
    return eChangeSummarySetting;
  }

} //SDOFactoryImpl
