/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.models.sql.schema.helper;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;

public class DatabaseHelper {
    public static Schema findSchema(Database database, String schemaName) {
        Schema returnSchema = null;
        Iterator it = database.getSchemas().iterator();
        while (it.hasNext()) {
            Schema schema = (Schema)it.next();
            if (DatabaseHelper.compareIdentifiers(database, schema.getName(), schemaName) != 0) continue;
            returnSchema = schema;
        }
        return returnSchema;
    }

    public static List findTables(Database database, String tableName) {
        Vector<Table> returnTables = new Vector<Table>();
        Iterator schemaIt = database.getSchemas().iterator();
        while (schemaIt.hasNext()) {
            Schema schema = (Schema)schemaIt.next();
            Iterator tableIt = schema.getTables().iterator();
            while (tableIt.hasNext()) {
                Table table = (Table)tableIt.next();
                if (DatabaseHelper.compareIdentifiers(database, table.getName(), tableName) != 0) continue;
                returnTables.add(table);
            }
        }
        return returnTables;
    }

    public static int compareIdentifiers(Database database, String identifier, String lookupName) {
        int compResult = -1;
        String delimiter = "\"";
        if (lookupName.startsWith(delimiter)) {
            if (identifier.startsWith(delimiter)) {
                compResult = identifier.compareTo(lookupName);
            } else if (lookupName.endsWith(delimiter)) {
                String lookupNameContent = lookupName.substring(1, lookupName.length() - 1);
                compResult = identifier.compareTo(lookupNameContent);
            }
        } else {
            compResult = identifier.compareToIgnoreCase(lookupName);
        }
        return compResult;
    }
}

