/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.migration;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.internal.migration.J2EEMigrationStatus;
import org.eclipse.jst.j2ee.internal.migration.J2EESpecificationMigrationConstants;
import org.eclipse.jst.j2ee.jsp.JSPConfig;
import org.eclipse.jst.j2ee.jsp.JspFactory;
import org.eclipse.jst.j2ee.jsp.TagLibRefType;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.j2ee.webapplication.Filter;
import org.eclipse.jst.j2ee.webapplication.InitParam;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.TagLibRef;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class War14SpecificationMigrator {
    public J2EEMigrationStatus migrateWebAppTo14(WebApp app) {
        this.migrateTabLibs(app);
        this.migrateContextParam(app);
        this.migrateInitParams(app);
        return new J2EEMigrationStatus(0, new J2EEMigrationStatus().format(J2EESpecificationMigrationConstants.DEFAULT_COMPLETED_STATUS_MSG, app.getDisplayName()));
    }

    private void migrateInitParams(WebApp app) {
        this.migrateServletInitParams(app);
        this.migrateFilterInitParams(app);
    }

    private void migrateFilterInitParams(WebApp app) {
        EList filters = app.getFilters();
        if (filters != null && !filters.isEmpty()) {
            int i = 0;
            while (i < filters.size()) {
                Filter filter = (Filter)filters.get(i);
                EList initParam = filter.getInitParams();
                int j = 0;
                while (j < initParam.size()) {
                    InitParam param = (InitParam)initParam.get(j);
                    if (param != null) {
                        ParamValue cParam = this.createParamValue(param);
                        EList contextParams = filter.getInitParamValues();
                        if (!this.paramValueExist((List)contextParams, cParam)) {
                            filter.getInitParamValues().add((Object)cParam);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void migrateServletInitParams(WebApp app) {
        EList servlets = app.getServlets();
        if (servlets != null && !servlets.isEmpty()) {
            int i = 0;
            while (i < servlets.size()) {
                Servlet servlet = (Servlet)servlets.get(i);
                EList initParam = servlet.getParams();
                int j = 0;
                while (j < initParam.size()) {
                    InitParam param = (InitParam)initParam.get(j);
                    if (param != null) {
                        ParamValue cParam = this.createParamValue(param);
                        EList contextParams = servlet.getInitParams();
                        if (!this.paramValueExist((List)contextParams, cParam)) {
                            servlet.getInitParams().add((Object)cParam);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private ParamValue createParamValue(InitParam param) {
        ParamValue cParam = CommonFactory.eINSTANCE.createParamValue();
        cParam.setName(param.getParamName());
        cParam.setValue(param.getParamValue());
        String desc = param.getDescription();
        if (desc != null && desc.length() > 0) {
            cParam.getDescriptions().add(this.createDescription(desc));
        }
        return cParam;
    }

    private Object createDescription(String desc) {
        Description description = CommonFactory.eINSTANCE.createDescription();
        description.setValue(desc);
        return description;
    }

    private boolean paramValueExist(List contextParams, ParamValue param) {
        boolean exists = false;
        int i = 0;
        while (i < contextParams.size()) {
            ParamValue paramValue = (ParamValue)contextParams.get(i);
            if (paramValue.getName().equals(param.getName()) && paramValue.getValue().equals(param.getValue())) {
                exists = true;
                break;
            }
            ++i;
        }
        return exists;
    }

    private boolean tagLibURITypeExists(List tagLibsURITypes, TagLibRefType tlut) {
        boolean exists = false;
        int i = 0;
        while (i < tagLibsURITypes.size()) {
            TagLibRefType tempTlut = (TagLibRefType)tagLibsURITypes.get(i);
            if (tempTlut.getTaglibLocation().equals(tlut.getTaglibLocation()) && tempTlut.getTaglibURI().equals(tempTlut.getTaglibURI())) {
                exists = true;
                break;
            }
            ++i;
        }
        return exists;
    }

    private void migrateContextParam(WebApp app) {
        EList contexts = app.getContexts();
        if (contexts != null && !contexts.isEmpty()) {
            int j = 0;
            while (j < contexts.size()) {
                ContextParam param = (ContextParam)contexts.get(j);
                if (param != null) {
                    ParamValue cParam = CommonFactory.eINSTANCE.createParamValue();
                    cParam.setName(param.getParamName());
                    cParam.setValue(param.getParamValue());
                    cParam.setDescription(param.getDescription());
                    EList contextParams = app.getContextParams();
                    if (!this.paramValueExist((List)contextParams, cParam)) {
                        app.getContextParams().add((Object)cParam);
                    }
                }
                ++j;
            }
        }
    }

    private void migrateTabLibs(WebApp app) {
        EList tagLibs = app.getTagLibs();
        JSPConfig config = app.getJspConfig();
        if (tagLibs != null && !tagLibs.isEmpty()) {
            if (config == null) {
                config = JspFactory.eINSTANCE.createJSPConfig();
                app.setJspConfig(config);
                config = app.getJspConfig();
            }
            int i = 0;
            while (i < tagLibs.size()) {
                TagLibRef tlr = (TagLibRef)tagLibs.get(i);
                TagLibRefType tlrt = JspFactory.eINSTANCE.createTagLibRefType();
                tlrt.setTaglibLocation(tlr.getTaglibLocation());
                tlrt.setTaglibURI(tlr.getTaglibURI());
                EList tagLibRefTypes = config.getTagLibs();
                if (!this.tagLibURITypeExists((List)tagLibRefTypes, tlrt)) {
                    config.getTagLibs().add((Object)tlrt);
                }
                ++i;
            }
        }
    }
}

