/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.internal.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jst.server.generic.servertype.definition.ArchiveType;
import org.eclipse.jst.server.generic.servertype.definition.Property;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;

public class Resolver {
    private Map fPropertyValues = new HashMap();
    private ServerRuntime server;

    public Resolver(ServerRuntime runtime) {
        this.server = runtime;
    }

    public List resolveClasspathProperties(List cpList) {
        ArrayList<String> list = new ArrayList<String>(cpList.size());
        int i = 0;
        while (i < cpList.size()) {
            ArchiveType item = (ArchiveType)cpList.get(i);
            String cpath = this.resolveProperties(item.getPath());
            list.add(cpath);
            ++i;
        }
        return list;
    }

    public String resolveProperties(String proppedString) {
        HashMap<String, String> cache = new HashMap<String, String>(this.getProperties().size());
        Iterator itr = this.getProperties().iterator();
        while (itr.hasNext()) {
            Property element = (Property)itr.next();
            String value = element.getDefault();
            if (this.fPropertyValues != null && this.fPropertyValues.containsKey(element.getId())) {
                value = (String)this.fPropertyValues.get(element.getId());
            }
            if ("directory".equals(element.getType()) || "file".equals(element.getType())) {
                value = value.replace('\\', '/');
            }
            cache.put(element.getId(), value);
        }
        cache.put("jrePath", "JRE");
        String str = this.resolvePropertiesFromCache(proppedString, cache);
        str = this.fixPassthroughProperties(str);
        return str;
    }

    private List getProperties() {
        return this.server.getProperty();
    }

    private String fixPassthroughProperties(String str) {
        String resolvedString = str;
        if (this.isPassPropertyLeft(resolvedString)) {
            resolvedString = this.fixParam(resolvedString);
            resolvedString = this.fixPassthroughProperties(resolvedString);
        }
        return resolvedString;
    }

    private String resolvePropertiesFromCache(String proppedString, HashMap cache) {
        String resolvedString = proppedString;
        int start = this.skipToProperty(resolvedString, cache);
        if (start >= 0) {
            resolvedString = this.resolveProperty(resolvedString, start, cache);
            resolvedString = this.resolvePropertiesFromCache(resolvedString, cache);
        }
        return resolvedString;
    }

    private int skipToProperty(String str, HashMap cache) {
        String key;
        int start = -1;
        int end = 0;
        String value = null;
        do {
            if ((start = str.indexOf("${", end)) >= 0) continue;
            return start;
        } while ((value = (String)cache.get(key = str.substring(start + 2, end = str.indexOf("}", start)))) == null);
        return start;
    }

    private boolean isPassPropertyLeft(String str) {
        return str.indexOf("%{") >= 0;
    }

    private String resolveProperty(String proppedString, int start, HashMap cache) {
        int end;
        String str = proppedString;
        start = str.indexOf("${");
        String key = str.substring(start + 2, end = str.indexOf("}", start));
        String value = (String)cache.get(key);
        if (value == null) {
            return str;
        }
        return String.valueOf(str.substring(0, start)) + value + str.substring(end + 1);
    }

    private String fixParam(String proppedString) {
        String str = proppedString;
        int start = str.indexOf("%{");
        return String.valueOf(str.substring(0, start)) + "${" + str.substring(start + 2);
    }

    public Map getPropertyValues() {
        return this.fPropertyValues;
    }

    public void setPropertyValues(Map propertyValues) {
        this.fPropertyValues = propertyValues;
    }
}

