/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ProjectProperties;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.ServerPreferences;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.core.internal.Trace;

public class ServerType
implements IServerType {
    protected IConfigurationElement element;

    public ServerType(IConfigurationElement element) {
        this.element = element;
    }

    protected IConfigurationElement getElement() {
        return this.element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public String getName() {
        return this.element.getAttribute("name");
    }

    public boolean startBeforePublish() {
        return "true".equals(this.element.getAttribute("startBeforePublish"));
    }

    public String getDescription() {
        return this.element.getAttribute("description");
    }

    public IRuntimeType getRuntimeType() {
        String typeId = this.element.getAttribute("runtimeTypeId");
        if (typeId == null) {
            return null;
        }
        return ServerCore.findRuntimeType(typeId);
    }

    public boolean hasRuntime() {
        String s = this.element.getAttribute("runtime");
        return "true".equals(s);
    }

    public ILaunchConfigurationType getLaunchConfigurationType() {
        String launchConfigId = this.element.getAttribute("launchConfigId");
        if (launchConfigId == null) {
            return null;
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        return launchManager.getLaunchConfigurationType(launchConfigId);
    }

    public boolean supportsLaunchMode(String launchMode) {
        ILaunchConfigurationType configType = this.getLaunchConfigurationType();
        if (configType == null) {
            String mode = this.element.getAttribute("launchModes");
            if (mode == null) {
                return false;
            }
            return mode.indexOf(launchMode) >= 0;
        }
        return configType.supportsMode(launchMode);
    }

    public boolean supportsRemoteHosts() {
        String hosts = this.element.getAttribute("supportsRemoteHosts");
        return hosts != null && hosts.toLowerCase().equals("true");
    }

    public byte getInitialState() {
        String stateString = this.element.getAttribute("initialState");
        if (stateString != null) {
            stateString = stateString.toLowerCase();
        }
        if ("stopped".equals(stateString)) {
            return 4;
        }
        if ("started".equals(stateString)) {
            return 2;
        }
        return 0;
    }

    public boolean hasServerConfiguration() {
        return "true".equalsIgnoreCase(this.element.getAttribute("hasConfiguration"));
    }

    public IServerWorkingCopy createServer(String id, IFile file, IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        if (id == null || id.length() == 0) {
            id = ServerPlugin.generateId();
        }
        ServerWorkingCopy swc = new ServerWorkingCopy(id, file, runtime, this);
        swc.setRuntime(runtime);
        swc.setDefaults(monitor);
        if (swc.getServerType().hasServerConfiguration()) {
            swc.importConfiguration(runtime, null);
        }
        return swc;
    }

    protected static IRuntime[] getRuntimes(IRuntimeType runtimeType) {
        ArrayList<IRuntime> list = new ArrayList<IRuntime>();
        IRuntime[] runtimes = ServerCore.getRuntimes();
        if (runtimes != null) {
            int size = runtimes.length;
            int i = 0;
            while (i < size) {
                if (runtimes[i].getRuntimeType() != null && runtimes[i].getRuntimeType().equals(runtimeType)) {
                    list.add(runtimes[i]);
                }
                ++i;
            }
        }
        IRuntime[] r = new IRuntime[list.size()];
        list.toArray(r);
        return r;
    }

    public IServerWorkingCopy createServer(String id, IFile file, IProgressMonitor monitor) throws CoreException {
        if (id == null || id.length() == 0) {
            id = ServerPlugin.generateId();
        }
        IRuntime runtime = null;
        if (this.hasRuntime()) {
            IRuntimeType runtimeType = this.getRuntimeType();
            IRuntime[] runtimes = ServerType.getRuntimes(runtimeType);
            if (runtimes != null && runtimes.length > 0) {
                runtime = runtimes[0];
            } else {
                try {
                    IRuntimeWorkingCopy runtimeWC = runtimeType.createRuntime(String.valueOf(id) + "-runtime", monitor);
                    ServerUtil.setRuntimeDefaultName(runtimeWC);
                    runtime = runtimeWC;
                }
                catch (Exception e) {
                    Trace.trace(Trace.SEVERE, "Couldn't create runtime", e);
                }
            }
        }
        ServerWorkingCopy swc = new ServerWorkingCopy(id, file, runtime, this);
        ServerUtil.setServerDefaultName(swc);
        if (runtime != null) {
            swc.setRuntime(runtime);
        }
        if (swc.getServerType().hasServerConfiguration()) {
            swc.importConfiguration(runtime, null);
        }
        swc.setDefaults(monitor);
        return swc;
    }

    public static IProject getServerProject() throws CoreException {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projects != null) {
            int size = projects.length;
            int i = 0;
            while (i < size) {
                if (((ProjectProperties)ServerCore.getProjectProperties(projects[i])).isServerProject()) {
                    return projects[i];
                }
                ++i;
            }
        }
        String s = ServerType.findUnusedServerProjectName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(s);
        project.create(null);
        project.open(null);
        ((ProjectProperties)ServerCore.getProjectProperties(project)).setServerProject(true, null);
        return project;
    }

    protected static String findUnusedServerProjectName() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String name = NLS.bind((String)Messages.defaultServerProjectName, (Object)"");
        int count = 1;
        while (root.getProject(name).exists()) {
            name = NLS.bind((String)Messages.defaultServerProjectName, (Object)String.valueOf(++count));
        }
        return name;
    }

    public int getStartTimeout() {
        try {
            int i = Integer.parseInt(this.element.getAttribute("startTimeout"));
            int s = ServerPreferences.getInstance().getMachineSpeed();
            i = i * (10 - s) / 5;
            return i;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public int getStopTimeout() {
        try {
            return Integer.parseInt(this.element.getAttribute("stopTimeout"));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public String toString() {
        return "ServerType[" + this.getId() + "]";
    }
}

