/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.IMonitoredServerPort;
import org.eclipse.wst.server.core.internal.IServerMonitor;
import org.eclipse.wst.server.core.internal.IServerMonitorManager;
import org.eclipse.wst.server.core.internal.ServerMonitor;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.XMLMemento;

public class ServerMonitorManager
implements IServerMonitorManager {
    private static final String MONITOR_DATA_FILE = "monitors.xml";
    protected static ServerMonitorManager instance;
    protected List ports = new ArrayList();
    protected ServerMonitor monitor;

    public ServerMonitorManager() {
        IServerMonitor[] monitors = ServerPlugin.getServerMonitors();
        if (monitors != null && monitors.length > 0) {
            this.monitor = (ServerMonitor)monitors[0];
        }
        instance = this;
        this.loadMonitors();
    }

    public static ServerMonitorManager getInstance() {
        if (instance == null) {
            new ServerMonitorManager();
        }
        return instance;
    }

    public static void shutdown() {
        if (instance == null) {
            return;
        }
        instance.saveMonitors();
    }

    public IServerMonitor getCurrentServerMonitor() {
        return this.monitor;
    }

    public void setServerMonitor(IServerMonitor newMonitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, "Not implemented yet", null));
    }

    public IMonitoredServerPort[] getMonitoredPorts(IServer server) {
        ArrayList<MonitoredPort> list = new ArrayList<MonitoredPort>();
        Iterator iterator = this.ports.iterator();
        while (iterator.hasNext()) {
            MonitoredPort mp = (MonitoredPort)iterator.next();
            if (!mp.server.equals(server)) continue;
            list.add(mp);
        }
        IMonitoredServerPort[] msp = new IMonitoredServerPort[list.size()];
        list.toArray(msp);
        return msp;
    }

    public IMonitoredServerPort createMonitor(IServer server, ServerPort port, int monitorPort, String[] content) {
        if (port == null || this.monitor == null) {
            return null;
        }
        MonitoredPort mp = new MonitoredPort(server, port, monitorPort, content);
        this.ports.add(mp);
        return mp;
    }

    public void removeMonitor(IMonitoredServerPort port) {
        if (port == null) {
            return;
        }
        try {
            this.ports.remove(port);
            if (port.isStarted()) {
                this.monitor.stopMonitoring(port.getServer(), port.getServerPort());
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not remove monitor", e);
        }
    }

    public void startMonitor(IMonitoredServerPort msp) throws CoreException {
        if (msp == null || msp.isStarted()) {
            return;
        }
        MonitoredPort port = (MonitoredPort)msp;
        port.setMonitorPort(this.monitor.startMonitoring(msp.getServer(), msp.getServerPort(), msp.getMonitorPort()));
        port.setStarted(true);
    }

    public void stopMonitor(IMonitoredServerPort msp) {
        if (msp == null || !msp.isStarted()) {
            return;
        }
        MonitoredPort port = (MonitoredPort)msp;
        this.monitor.stopMonitoring(msp.getServer(), msp.getServerPort());
        port.setStarted(false);
    }

    public int getMonitoredPort(IServer server, int port, String content) {
        try {
            Iterator iterator = this.ports.iterator();
            while (iterator.hasNext()) {
                MonitoredPort mp = (MonitoredPort)iterator.next();
                if (!mp.isStarted() || !mp.server.equals(server) || mp.port.getPort() != port) continue;
                String[] contentTypes = mp.getContentTypes();
                boolean found = false;
                if (content == null || contentTypes != null) {
                    int size = contentTypes.length;
                    int i = 0;
                    while (i < size) {
                        if (content.equals(contentTypes[i])) {
                            found = true;
                        }
                        ++i;
                    }
                } else {
                    found = true;
                }
                if (!found || mp.newPort == -1) continue;
                return mp.newPort;
            }
        }
        catch (Exception exception) {}
        return port;
    }

    protected void saveMonitors() {
        String filename = ServerPlugin.getInstance().getStateLocation().append(MONITOR_DATA_FILE).toOSString();
        try {
            XMLMemento memento = XMLMemento.createWriteRoot("monitors");
            Iterator iterator = this.ports.iterator();
            while (iterator.hasNext()) {
                MonitoredPort mp = (MonitoredPort)iterator.next();
                if (!mp.canSave()) continue;
                IMemento child = memento.createChild("monitor");
                mp.save(child);
            }
            memento.saveToFile(filename);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error saving monitor info", e);
        }
    }

    protected void loadMonitors() {
        Trace.trace(Trace.FINEST, "Loading monitor info");
        String filename = ServerPlugin.getInstance().getStateLocation().append(MONITOR_DATA_FILE).toOSString();
        try {
            IMemento memento = XMLMemento.loadMemento(filename);
            IMemento[] children = memento.getChildren("monitor");
            int size = children.length;
            int i = 0;
            while (i < size) {
                try {
                    MonitoredPort mp = new MonitoredPort(children[i], null);
                    this.ports.add(mp);
                }
                catch (Exception e) {
                    Trace.trace(Trace.WARNING, "Could not load monitor: " + e);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Could not load monitor info: " + e.getMessage());
        }
    }

    class MonitoredPort
    implements IMonitoredServerPort {
        protected IServer server;
        protected ServerPort port;
        protected int newPort = -1;
        protected String[] content;
        public boolean started;

        public MonitoredPort(IServer server, ServerPort port, int newPort, String[] content) {
            this.server = server;
            this.port = port;
            this.newPort = newPort;
            this.content = content;
        }

        public MonitoredPort(IMemento memento, IProgressMonitor monitor) {
            this.load(memento, monitor);
        }

        public IServer getServer() {
            return this.server;
        }

        public ServerPort getServerPort() {
            return this.port;
        }

        public int getMonitorPort() {
            return this.newPort;
        }

        public void setMonitorPort(int p) {
            this.newPort = p;
        }

        public String[] getContentTypes() {
            if (this.content == null) {
                return new String[0];
            }
            return this.content;
        }

        public boolean isStarted() {
            return this.started;
        }

        protected void setStarted(boolean s) {
            this.started = s;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MonitoredPort)) {
                return false;
            }
            MonitoredPort mp = (MonitoredPort)obj;
            if (!mp.server.equals(this.server)) {
                return false;
            }
            if (!mp.port.equals(this.port)) {
                return false;
            }
            if (this.newPort != mp.newPort) {
                return false;
            }
            if (this.content == null && mp.content != null) {
                return false;
            }
            if (this.content != null && mp.content == null) {
                return false;
            }
            if (this.content != null) {
                int size = this.content.length;
                if (size != mp.content.length) {
                    return false;
                }
                int i = 0;
                while (i < size) {
                    if (!this.content[i].equals(mp.content[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        protected boolean canSave() {
            return this.port.getId() != null;
        }

        protected void save(IMemento memento) {
            memento.putString("serverId", this.server.getId());
            if (this.newPort != -1) {
                memento.putString("port", String.valueOf(this.newPort));
            }
            memento.putString("portId", this.port.getId());
            memento.putBoolean("started", this.started);
            if (this.content != null) {
                StringBuffer sb = new StringBuffer();
                int size = this.content.length;
                int i = 0;
                while (i < size) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(this.content[i]);
                    ++i;
                }
                memento.putString("contentTypes", sb.toString());
            }
        }

        protected void load(IMemento memento, IProgressMonitor monitor2) {
            Boolean b;
            String serverId = memento.getString("serverId");
            this.server = null;
            if (serverId != null) {
                this.server = ServerCore.findServer(serverId);
            }
            if (this.server == null) {
                throw new RuntimeException("Server could not be found: " + serverId + " " + this.server);
            }
            String newPortStr = memento.getString("port");
            if (newPortStr != null && newPortStr.length() > 0) {
                this.newPort = Integer.parseInt(newPortStr);
            }
            String portId = memento.getString("portId");
            ServerPort[] ports2 = this.server.getServerPorts(monitor2);
            if (ports2 != null) {
                int size = ports2.length;
                int i = 0;
                while (this.port == null && i < size) {
                    ServerPort sp = ports2[i];
                    if (sp.getId() != null && sp.getId().equals(portId)) {
                        this.port = sp;
                    }
                    ++i;
                }
            }
            if (this.port == null) {
                throw new RuntimeException("Could not relocate port: " + serverId + " " + this.server + " " + portId);
            }
            String s = memento.getString("contentTypes");
            if (s != null) {
                this.content = ServerPlugin.tokenize(s, ",");
            }
            if ((b = memento.getBoolean("started")) != null && b.booleanValue()) {
                try {
                    this.newPort = ServerMonitorManager.this.monitor.startMonitoring(this.server, this.port, this.newPort);
                    this.started = true;
                }
                catch (CoreException e) {
                    Trace.trace(Trace.WARNING, "Could not restart server monitor", e);
                }
            }
        }
    }
}

