/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.ModuleFile;
import org.eclipse.wst.server.core.internal.ModuleFolder;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;

public class ModulePublishInfo {
    private static final String MODULE_ID = "module-ids";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private static final String STAMP = "stamp";
    private static final String FILE = "file";
    private static final String FOLDER = "folder";
    private String moduleId;
    private String name;
    private IModuleResource[] resources = new IModuleResource[0];

    public ModulePublishInfo(String moduleId, String name) {
        this.moduleId = moduleId;
        this.name = name;
    }

    public ModulePublishInfo(IMemento memento) {
        this.load(memento);
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getName() {
        return this.name;
    }

    public IModuleResource[] getResources() {
        return this.resources;
    }

    public void setResources(IModuleResource[] res) {
        this.resources = res;
    }

    protected void load(IMemento memento) {
        Trace.trace(Trace.FINEST, "Loading module publish info for: " + memento);
        try {
            this.moduleId = memento.getString(MODULE_ID);
            this.name = memento.getString(NAME);
            this.resources = this.loadResource(memento);
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Could not load module publish info information: " + e.getMessage());
        }
    }

    protected IModuleResource[] loadResource(IMemento memento) {
        Path path;
        String name2;
        int i;
        int size;
        if (memento == null) {
            return new IModuleResource[0];
        }
        ArrayList<IModuleResource> list = new ArrayList<IModuleResource>(5);
        IMemento[] children = memento.getChildren(FILE);
        if (children != null) {
            size = children.length;
            i = 0;
            while (i < size) {
                name2 = children[i].getString(NAME);
                path = new Path(children[i].getString(PATH));
                long stamp = Long.parseLong(children[i].getString(STAMP));
                ModuleFile file = new ModuleFile(null, name2, (IPath)path, stamp);
                list.add(file);
                ++i;
            }
        }
        if ((children = memento.getChildren(FOLDER)) != null) {
            size = children.length;
            i = 0;
            while (i < size) {
                name2 = children[i].getString(NAME);
                path = new Path(children[i].getString(PATH));
                ModuleFolder folder = new ModuleFolder(null, name2, (IPath)path);
                folder.setMembers(this.loadResource(children[i]));
                list.add(folder);
                ++i;
            }
        }
        IModuleResource[] resources2 = new IModuleResource[list.size()];
        list.toArray(resources2);
        return this.resources;
    }

    protected void save(IMemento memento) {
        try {
            memento.putString(MODULE_ID, this.moduleId);
            if (this.name != null) {
                memento.putString(NAME, this.name);
            }
            this.saveResource(memento, this.resources);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not save module publish info", e);
        }
    }

    protected void saveResource(IMemento memento, IModuleResource[] resources2) {
        if (resources2 == null) {
            return;
        }
        int size = resources2.length;
        int i = 0;
        while (i < size) {
            IMemento child;
            if (resources2[i] instanceof IModuleFile) {
                IModuleFile file = (IModuleFile)resources2[i];
                child = memento.createChild(FILE);
                child.putString(NAME, file.getName());
                child.putString(PATH, file.getModuleRelativePath().toPortableString());
                child.putString(STAMP, "" + file.getModificationStamp());
            } else {
                IModuleFolder folder = (IModuleFolder)resources2[i];
                child = memento.createChild(FOLDER);
                child.putString(NAME, folder.getName());
                child.putString(PATH, folder.getModuleRelativePath().toPortableString());
                IModuleResource[] resources3 = folder.members();
                this.saveResource(child, resources3);
            }
            ++i;
        }
    }

    public String toString() {
        return "ModulePublishInfo [" + this.moduleId + "]";
    }
}

