/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench.operation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.importer.java.builder.JavaEcoreBuilder;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel;
import org.eclipse.wst.common.internal.emfworkbench.operation.DataObjectGeneratorModel;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;

public class DataObjectGenerator
extends WTPOperation {
    protected IProject project;
    protected List xmiPackages;
    protected List javaModels;
    protected XSDEcoreBuilder xsdECoreBuilder;
    protected List ePackages;

    public DataObjectGenerator(DataObjectGeneratorModel operationDataModel) {
        super((WTPOperationDataModel)operationDataModel);
    }

    public static void setStaticPackageNsURI(EPackage ePackage, String fullyQualifiedPackageInterfaceName) {
        if (ePackage != null && fullyQualifiedPackageInterfaceName != null) {
            ePackage.setNsURI("java://" + fullyQualifiedPackageInterfaceName);
        }
    }

    protected IProject getProject() {
        if (this.project == null) {
            this.project = (IProject)this.operationDataModel.getProperty("DataObjectGeneratorModel.project");
        }
        return this.project;
    }

    protected XSDEcoreBuilder getXSDEcoreBuilder() {
        if (this.xsdECoreBuilder == null) {
            this.xsdECoreBuilder = new XSDEcoreBuilder();
        }
        return this.xsdECoreBuilder;
    }

    protected boolean prepareGenerate() {
        this.ePackages = new ArrayList();
        if (this.xsdECoreBuilder != null) {
            this.ePackages.addAll(this.xsdECoreBuilder.getTargetNamespaceToEPackageMap().values());
        }
        if (this.xmiPackages != null) {
            this.ePackages.addAll(this.xmiPackages);
        }
        if (this.javaModels != null) {
            this.prepareEPackagesFromJavaModels();
        }
        return !this.ePackages.isEmpty();
    }

    protected void prepareEPackagesFromJavaModels() {
        JavaEcoreBuilder javaEcoreBuilder = new JavaEcoreBuilder(this.getProject().getFile((IPath)new Path("sdo.genmodel"))){

            public void getAllGenModelFiles(Collection result, IFile file) throws CoreException {
            }
        };
        IStatus localStatus = javaEcoreBuilder.getStatus();
        if (localStatus.getSeverity() != 4) {
            EList genPackages = javaEcoreBuilder.getGenModel().getGenPackages();
            this.processGenPackagesFromJavaModels((List)genPackages);
        } else {
            this.logProblems(localStatus);
        }
    }

    private void logProblems(IStatus statusArg) {
        Logger logger = Logger.getLogger();
        logger.logError("Problems detected generating SDO objects.");
        this.log(statusArg, logger);
    }

    private void log(IStatus statusArg, Logger logger) {
        this.doLog(statusArg, logger);
        if (statusArg.isMultiStatus()) {
            MultiStatus mStatus = (MultiStatus)statusArg;
            IStatus[] children = mStatus.getChildren();
            int i = 0;
            while (i < children.length) {
                this.log(children[i], logger);
                ++i;
            }
        }
    }

    private void doLog(IStatus statusArg, Logger logger) {
        switch (statusArg.getSeverity()) {
            case 4: {
                logger.logError(statusArg.getMessage());
                break;
            }
            case 2: {
                logger.logWarning(statusArg.getMessage());
                break;
            }
            case 1: {
                logger.log((Object)statusArg.getMessage());
            }
        }
    }

    protected void processGenPackagesFromJavaModels(List genPackages) {
        if (genPackages.isEmpty()) {
            return;
        }
        Iterator i = genPackages.iterator();
        while (i.hasNext()) {
            GenPackage genPackage = (GenPackage)i.next();
            EPackage ePackage = genPackage.getEcorePackage();
            this.updateEPackageFromJavaModel(ePackage, genPackage);
            this.ePackages.add(ePackage);
        }
    }

    protected void updateEPackageFromJavaModel(EPackage ePackage, GenPackage genPackage) {
        ePackage.setName(ePackage.getNsPrefix());
        this.setStaticPackageNsURI(ePackage, genPackage);
    }

    protected void setStaticPackageNsURI(EPackage ePackage, GenPackage genPackage) {
        String interfaceName = genPackage.getPackageInterfaceName();
        if (interfaceName != null) {
            StringBuffer b = new StringBuffer();
            b.append(genPackage.getPackageName()).append('.').append(interfaceName);
            DataObjectGenerator.setStaticPackageNsURI(ePackage, b.toString());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generate(IProgressMonitor progressMonitor) throws CoreException {
        try {
            progressMonitor.beginTask(this.getProject().getFullPath().toString(), 100);
            GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
            this.initializeGenModel(genModel);
            this.setPackagesOnGenModel(genModel);
            IStatus localStatus = genModel.validate();
            if (!localStatus.isOK()) {
                throw new CoreException(localStatus);
            }
            this.doGenerate(progressMonitor, genModel);
            progressMonitor.worked(100);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            progressMonitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        progressMonitor.done();
    }

    protected void doGenerate(IProgressMonitor progressMonitor, GenModel genModel) {
        try {
            genModel.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 50));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void setPackagesOnGenModel(GenModel genModel) {
        genModel.initialize((Collection)this.ePackages);
        Iterator i = genModel.getGenPackages().iterator();
        while (i.hasNext()) {
            GenPackage genPackage = (GenPackage)i.next();
            genPackage.setLoadInitialization(false);
            String prefix = genPackage.getInterfacePackageName();
            prefix = prefix.substring(prefix.lastIndexOf(46) + 1);
            prefix = prefix.length() > 1 ? String.valueOf(prefix.substring(0, 1).toUpperCase()) + prefix.substring(1) : prefix.toUpperCase();
            genPackage.setPrefix(prefix);
        }
    }

    protected void initializeGenModel(GenModel genModel) {
        this.setSDODefaults(genModel);
        genModel.setDynamicTemplates(this.operationDataModel.getBooleanProperty("DataObjectGeneratorModel.dynamicTemplates"));
        genModel.setForceOverwrite(this.operationDataModel.getBooleanProperty("DataObjectGeneratorModel.forceOverwrite"));
        genModel.setCanGenerate(this.operationDataModel.getBooleanProperty("DataObjectGeneratorModel.canGenerate"));
        genModel.setUpdateClasspath(this.operationDataModel.getBooleanProperty("DataObjectGeneratorModel.updateClasspath"));
        genModel.setGenerateSchema(this.operationDataModel.getBooleanProperty("DataObjectGeneratorModel.generateSchema"));
        genModel.setNonNLSMarkers(this.operationDataModel.getBooleanProperty("DataObjectGeneratorModel.nonNLSMarkers"));
        IFolder modelDir = (IFolder)this.operationDataModel.getProperty("DataObjectGeneratorModel.modelDirectory");
        genModel.setModelDirectory(modelDir.getFullPath().toOSString());
    }

    protected void setSDODefaults(GenModel genModel) {
        genModel.setRootExtendsInterface("");
        genModel.setRootImplementsInterface("org.eclipse.emf.ecore.sdo.InternalEDataObject");
        genModel.setRootExtendsClass("org.eclipse.emf.ecore.sdo.impl.EDataObjectImpl");
        genModel.setFeatureMapWrapperInterface("commonj.sdo.Sequence");
        genModel.setFeatureMapWrapperInternalInterface("org.eclipse.emf.ecore.sdo.util.ESequence");
        genModel.setFeatureMapWrapperClass("org.eclipse.emf.ecore.sdo.util.BasicESequence");
        genModel.setSuppressEMFTypes(true);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.loadModelFiles(monitor);
        if (this.prepareGenerate()) {
            this.generate(monitor);
        }
    }

    protected void loadModelFiles(IProgressMonitor monitor) {
        this.loadXSDFiles(monitor);
        this.loadEcoreFiles(monitor);
        this.loadJavaFiles(monitor);
    }

    protected void loadXSDFiles(IProgressMonitor monitor) {
        if (this.operationDataModel.isSet("DataObjectGeneratorModel.xsdFiles")) {
            List files = (List)this.operationDataModel.getProperty("DataObjectGeneratorModel.xsdFiles");
            int i = 0;
            while (i < files.size()) {
                IFile file = (IFile)files.get(i);
                Resource resource = WorkbenchResourceHelperBase.load((IFile)file);
                Collection xsdSchemas = EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)XSDPackage.eINSTANCE.getXSDSchema());
                Iterator j = xsdSchemas.iterator();
                while (j.hasNext()) {
                    this.getXSDEcoreBuilder().generate((XSDSchema)j.next());
                }
                ++i;
            }
        }
    }

    protected void loadEcoreFiles(IProgressMonitor monitor) {
        if (this.operationDataModel.isSet("DataObjectGeneratorModel.ecoreFiles")) {
            List files = (List)this.operationDataModel.getProperty("DataObjectGeneratorModel.ecoreFiles");
            int i = 0;
            while (i < files.size()) {
                IFile file = (IFile)files.get(i);
                Resource resource = WorkbenchResourceHelperBase.getResource((IFile)file, (boolean)true);
                this.addXmiPackages((List)resource.getContents());
                ++i;
            }
        }
    }

    protected void addXmiPackages(List packages) {
        if (this.xmiPackages == null) {
            this.xmiPackages = new ArrayList();
        }
        this.xmiPackages.addAll(packages);
    }

    protected void loadWSDLFiles(IProgressMonitor monitor) {
    }

    protected void loadJavaFiles(IProgressMonitor monitor) {
        this.javaModels = (List)this.operationDataModel.getProperty("DataObjectGeneratorModel.javaFiles");
    }
}

