/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementManager;
import org.eclipse.wst.common.frameworks.internal.operations.ComposedExtendedOperationHolder;
import org.eclipse.wst.common.frameworks.internal.operations.OperationExtensibilityReader;
import org.eclipse.wst.common.frameworks.internal.operations.OperationExtension;
import org.eclipse.wst.common.frameworks.internal.operations.OperationExtensionReader;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;

public class OperationExtensionRegistry {
    protected static boolean canExtHasRead = false;
    protected static boolean extPointHasRead = false;
    protected static OperationExtensionRegistry instance = null;
    protected static HashMap extensibleOperations = null;
    protected static HashMap opExtensions = null;
    protected static OperationExtensibilityReader opExtensibilityReader = null;
    protected static OperationExtensionReader opExtensionReader = null;

    public static String[] getRegisteredOperations(String className) {
        extensibleOperations = OperationExtensionRegistry.getExtensibility();
        if (extensibleOperations != null) {
            Collection ext;
            String id = (String)extensibleOperations.get(className);
            if (id == null) {
                return null;
            }
            if (opExtensions == null) {
                opExtensions = OperationExtensionRegistry.getExtensionPoints();
            }
            if (opExtensions != null && (ext = (Collection)opExtensions.get(id)) != null) {
                return OperationExtensionRegistry.getClassNames(ext.toArray());
            }
        }
        return null;
    }

    private static String[] getClassNames(Object[] opExt) {
        ArrayList<String> classNames = new ArrayList<String>();
        OperationExtension currentExt = null;
        int i = 0;
        while (i < opExt.length) {
            currentExt = (OperationExtension)opExt[i];
            if (EnablementManager.INSTANCE.getIdentifier(currentExt.getExtensionId(), null).isEnabled()) {
                String className = currentExt.getPreOperationClass();
                if (className != null) {
                    classNames.add(className);
                }
                if ((className = currentExt.getPostOperationClass()) != null) {
                    classNames.add(className);
                }
            }
            ++i;
        }
        String[] array = new String[classNames.size()];
        classNames.toArray(array);
        return array;
    }

    public static ComposedExtendedOperationHolder getExtensions(String className) {
        extensibleOperations = OperationExtensionRegistry.getExtensibility();
        if (extensibleOperations != null) {
            Collection ext;
            String id = (String)extensibleOperations.get(className);
            if (id == null) {
                return null;
            }
            if (opExtensions == null) {
                opExtensions = OperationExtensionRegistry.getExtensionPoints();
            }
            if (opExtensions != null && (ext = (Collection)opExtensions.get(id)) != null) {
                try {
                    return OperationExtensionRegistry.calculateOperationHolder(ext);
                }
                catch (CoreException ex) {
                    Logger.getLogger().logError((Throwable)ex);
                }
            }
        }
        return null;
    }

    public static ComposedExtendedOperationHolder getExtensions(WTPOperation op) {
        return OperationExtensionRegistry.getExtensions(op.getClass().getName());
    }

    protected String getExtendableOperationId(WTPOperation op) {
        return (String)extensibleOperations.get(op.getClass().getName());
    }

    private static ComposedExtendedOperationHolder calculateOperationHolder(Collection ext) throws CoreException {
        Object[] opExt = ext.toArray();
        ComposedExtendedOperationHolder extOperationHolder = new ComposedExtendedOperationHolder();
        WTPOperation preOp = null;
        WTPOperation postOp = null;
        OperationExtension currentExt = null;
        int i = 0;
        while (i < opExt.length) {
            currentExt = (OperationExtension)opExt[i];
            if (EnablementManager.INSTANCE.getIdentifier(currentExt.getExtensionId(), null).isEnabled()) {
                preOp = currentExt.getPreOperation();
                if (preOp != null) {
                    extOperationHolder.addPreOperation(preOp);
                }
                if ((postOp = currentExt.getPostOperation()) != null) {
                    extOperationHolder.addPostOperation(postOp);
                }
            }
            ++i;
        }
        return extOperationHolder;
    }

    private static HashMap getExtensibility() {
        if (!canExtHasRead) {
            opExtensibilityReader = new OperationExtensibilityReader();
            opExtensibilityReader.readRegistry();
            canExtHasRead = true;
        }
        if (opExtensibilityReader == null) {
            return null;
        }
        return OperationExtensibilityReader.getExtendableOperations();
    }

    private static HashMap getExtensionPoints() {
        if (!extPointHasRead) {
            opExtensionReader = new OperationExtensionReader();
            opExtensionReader.readRegistry();
            extPointHasRead = true;
        }
        if (opExtensionReader == null) {
            return null;
        }
        return OperationExtensionReader.getExtensionPoints();
    }

    public static OperationExtensionRegistry getInstance() {
        if (instance == null) {
            instance = new OperationExtensionRegistry();
        }
        return instance;
    }
}

