/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;

public class OperationExtension {
    String opID = null;
    IConfigurationElement baseElement = null;
    String preOperationClass = null;
    WTPOperation preOperation = null;
    String postOperationClass = null;
    WTPOperation postOperation = null;
    private String extensionId;

    public OperationExtension(IConfigurationElement element, String id, String preOp, String postOp) {
        this.baseElement = element;
        this.setUpExtension(id, preOp, postOp);
    }

    private void setUpExtension(String id, String preOp, String postOp) {
        this.opID = id;
        this.preOperationClass = preOp;
        this.postOperationClass = postOp;
        this.extensionId = this.baseElement.getDeclaringExtension().getUniqueIdentifier();
        if (this.extensionId == null) {
            this.extensionId = this.baseElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier();
        }
    }

    public String getOpID() {
        return this.opID;
    }

    public String getPostOperationClass() {
        return this.postOperationClass;
    }

    public String getPreOperationClass() {
        return this.preOperationClass;
    }

    public WTPOperation getPostOperation() throws CoreException {
        if (this.postOperationClass == null) {
            return null;
        }
        WTPOperation op = (WTPOperation)this.baseElement.createExecutableExtension("postOperationClass");
        if (op != null) {
            op.setID(this.getExtensionId());
        }
        return op;
    }

    public WTPOperation getPreOperation() throws CoreException {
        if (this.preOperationClass == null) {
            return null;
        }
        WTPOperation op = (WTPOperation)this.baseElement.createExecutableExtension("preOperationClass");
        if (op != null) {
            op.setID(this.getExtensionId());
        }
        return op;
    }

    public IDataModelOperation getDMPostOperation() throws CoreException {
        if (this.postOperationClass == null) {
            return null;
        }
        IDataModelOperation op = (IDataModelOperation)this.baseElement.createExecutableExtension("postOperationClass");
        if (op != null) {
            op.setID(this.getExtensionId());
        }
        return op;
    }

    public IDataModelOperation getDMPreOperation() throws CoreException {
        if (this.preOperationClass == null) {
            return null;
        }
        IDataModelOperation op = (IDataModelOperation)this.baseElement.createExecutableExtension("preOperationClass");
        if (op != null) {
            op.setID(this.getExtensionId());
        }
        return op;
    }

    public String getExtensionId() {
        return this.extensionId;
    }
}

