/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.datamodel;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.AdaptabilityUtility;
import org.eclipse.wst.common.frameworks.internal.WTPResourceHandler;
import org.eclipse.wst.common.frameworks.internal.datamodel.IWorkspaceRunnableWithStatus;
import org.eclipse.wst.common.frameworks.internal.enablement.IEnablementManager;
import org.eclipse.wst.common.frameworks.internal.operations.DMComposedExtendedOperationHolder;
import org.eclipse.wst.common.frameworks.internal.operations.DMOperationExtensionRegistry;
import org.eclipse.wst.common.frameworks.internal.operations.OperationStatus;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public final class ExtendableOperationImpl
implements IDataModelOperation {
    private IDataModelOperation rootOperation;
    private List appendedOperations;
    private OperationStatus opStatus;
    static /* synthetic */ Class class$0;

    public ExtendableOperationImpl(IDataModelOperation rootOperation) {
        this.rootOperation = rootOperation;
        if (rootOperation == null) {
            throw new NullPointerException();
        }
    }

    private DMComposedExtendedOperationHolder initializeExtensionOperations() {
        return DMOperationExtensionRegistry.getExtensions(this.rootOperation);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
        return null;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.rootOperation.getSchedulingRule();
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
        return null;
    }

    public final void addStatus(IStatus aStatus) {
        if (this.opStatus == null) {
            this.opStatus = new OperationStatus(aStatus.getMessage(), aStatus.getException());
            this.opStatus.setSeverity(aStatus.getSeverity());
            this.opStatus.add(aStatus);
        } else {
            this.opStatus.add(aStatus);
        }
    }

    private void addExtendedStatus(IStatus aStatus) {
        if (this.opStatus == null) {
            this.opStatus = new OperationStatus(new IStatus[]{WTPCommonPlugin.OK_STATUS});
        }
        this.opStatus.addExtendedStatus(aStatus);
    }

    public void appendOperation(IDataModelOperation appendedOperation) {
        if (this.appendedOperations == null) {
            this.appendedOperations = new ArrayList(3);
        }
        this.appendedOperations.add(appendedOperation);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        InvocationTargetException[] cfr_ignored_0 = new InvocationTargetException[1];
        IWorkspaceRunnableWithStatus workspaceRunnable = new IWorkspaceRunnableWithStatus(info){

            public void run(IProgressMonitor pm) throws CoreException {
                this.setStatus(ExtendableOperationImpl.this.doExecute(pm, this.getInfo()));
            }
        };
        ISchedulingRule rule = this.getSchedulingRule();
        try {
            if (rule == null) {
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)workspaceRunnable, monitor);
            } else {
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)workspaceRunnable, rule, this.getOperationExecutionFlags(), monitor);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return workspaceRunnable.getStatus();
    }

    public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
        DMComposedExtendedOperationHolder extOpHolder = this.initializeExtensionOperations();
        IStatus preOpStatus = this.runPreOps(monitor, extOpHolder, info);
        try {
            this.addStatus(this.rootOperation.execute(monitor, info));
        }
        catch (ExecutionException e1) {
            this.addStatus((IStatus)new Status(4, "org.eclipse.wst.common.frameworks.internal", 0, e1.getMessage(), (Throwable)e1));
        }
        IStatus postOpStatus = this.runPostOps(monitor, extOpHolder, info);
        if (preOpStatus != null) {
            this.addExtendedStatus(preOpStatus);
        }
        if (postOpStatus != null) {
            this.addExtendedStatus(postOpStatus);
        }
        if (this.appendedOperations != null) {
            OperationStatus composedStatus = null;
            int i = 0;
            while (i < this.appendedOperations.size()) {
                try {
                    ExtendableOperationImpl op = new ExtendableOperationImpl((IDataModelOperation)this.appendedOperations.get(i));
                    IStatus status = op.execute((IProgressMonitor)new SubProgressMonitor(monitor, 1, 4), info);
                    if (composedStatus == null) {
                        composedStatus = new OperationStatus(new IStatus[]{status});
                    } else {
                        composedStatus.add(status);
                    }
                }
                catch (Exception e) {
                    Logger.getLogger().logError((Throwable)e);
                }
                ++i;
            }
            if (composedStatus != null) {
                this.addStatus((IStatus)composedStatus);
            }
        }
        return this.opStatus;
    }

    private IStatus runPreOps(IProgressMonitor pm, DMComposedExtendedOperationHolder extOpHolder, IAdaptable info) {
        IStatus preOpStatus = null;
        if (extOpHolder != null && extOpHolder.hasPreOps()) {
            preOpStatus = this.runExtendedOps(extOpHolder.getPreOps(), pm, info);
        }
        return preOpStatus;
    }

    private IStatus runPostOps(IProgressMonitor pm, DMComposedExtendedOperationHolder extOpHolder, IAdaptable info) {
        IStatus postOpStatus = null;
        if (extOpHolder != null && extOpHolder.hasPostOps()) {
            postOpStatus = this.runExtendedOps(extOpHolder.getPostOps(), pm, info);
        }
        return postOpStatus;
    }

    private IStatus runExtendedOps(List opList, IProgressMonitor pm, IAdaptable info) {
        IDataModel rootDataModel = this.rootOperation.getDataModel();
        IDataModelOperation nestedOp = null;
        OperationStatus returnStatus = null;
        String opId = null;
        int i = 0;
        while (i < opList.size()) {
            Status localStatus;
            nestedOp = (IDataModelOperation)opList.get(i);
            try {
                opId = nestedOp.getID();
                boolean shouldExtendedRun = true;
                List extendedContext = rootDataModel.getExtendedContext();
                int contextCount = 0;
                while (shouldExtendedRun && contextCount < extendedContext.size()) {
                    IProject project;
                    Object e = extendedContext.get(contextCount);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IProject");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((project = (IProject)AdaptabilityUtility.getAdapter(e, clazz)) != null && !IEnablementManager.INSTANCE.getIdentifier(opId, project).isEnabled()) {
                        shouldExtendedRun = false;
                    }
                    ++contextCount;
                }
                if (shouldExtendedRun) {
                    nestedOp.setDataModel(rootDataModel);
                    ExtendableOperationImpl extendedOp = new ExtendableOperationImpl(nestedOp);
                    localStatus = extendedOp.doExecute((IProgressMonitor)new SubProgressMonitor(pm, -1), info);
                } else {
                    localStatus = null;
                }
            }
            catch (Exception e) {
                localStatus = new Status(4, "org.eclipse.wst.common.frameworks", 0, WTPResourceHandler.getString("25", new Object[]{nestedOp.getClass().getName()}), (Throwable)e);
            }
            if (localStatus != null) {
                if (returnStatus == null) {
                    returnStatus = new OperationStatus(new IStatus[]{localStatus});
                } else {
                    returnStatus.add((IStatus)localStatus);
                }
            }
            ++i;
        }
        return returnStatus;
    }

    public void dispose() {
    }

    public boolean canExecute() {
        return this.rootOperation.canExecute();
    }

    public boolean canRedo() {
        return this.rootOperation.canRedo();
    }

    public boolean canUndo() {
        return this.rootOperation.canUndo();
    }

    public int getOperationExecutionFlags() {
        return this.rootOperation.getOperationExecutionFlags();
    }

    public String getLabel() {
        return this.rootOperation.getLabel();
    }

    public IUndoContext[] getContexts() {
        return this.rootOperation.getContexts();
    }

    public boolean hasContext(IUndoContext context) {
        return this.rootOperation.hasContext(context);
    }

    public void addContext(IUndoContext context) {
        this.rootOperation.addContext(context);
    }

    public void removeContext(IUndoContext context) {
        this.rootOperation.removeContext(context);
    }

    public void setID(String id) {
        this.rootOperation.setID(id);
    }

    public String getID() {
        return this.rootOperation.getID();
    }

    public void setDataModel(IDataModel model) {
        this.rootOperation.setDataModel(model);
    }

    public IDataModel getDataModel() {
        return this.rootOperation.getDataModel();
    }
}

