/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.provider;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.j2ee.ejb.annotation.internal.model.IEnterpriseBean;
import org.eclipse.jst.j2ee.ejb.annotation.internal.model.IMessageDrivenBean;
import org.eclipse.jst.j2ee.ejb.annotation.internal.model.ISessionBean;
import org.eclipse.jst.j2ee.ejb.annotation.internal.model.MessageDrivenBeanDataModel;
import org.eclipse.jst.j2ee.ejb.annotation.internal.model.SessionBeanDataModel;
import org.eclipse.jst.j2ee.ejb.annotation.internal.provider.IAnnotationProvider;
import org.eclipse.jst.j2ee.ejb.annotation.internal.provider.IEJBGenerator;
import org.eclipse.jst.j2ee.ejb.annotations.internal.classgen.EjbBuilder;
import org.eclipse.jst.j2ee.ejb.annotations.internal.emitter.EmitterUtilities;
import org.eclipse.jst.j2ee.ejb.annotations.internal.emitter.MessageDrivenEjbEmitter;
import org.eclipse.jst.j2ee.ejb.annotations.internal.emitter.SessionEjbEmitter;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletPreferenceStore;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletRuntime;

public class XDocletAnnotationProvider
implements IAnnotationProvider,
IEJBGenerator {
    public boolean isEjbAnnotationProvider() {
        return true;
    }

    public boolean isServletAnnotationProvider() {
        return true;
    }

    public boolean isWebServiceAnnotationProvider() {
        return false;
    }

    public boolean isValid() {
        XDocletRuntime runtime = new XDocletRuntime();
        runtime.setHome(XDocletPreferenceStore.getProperty("XDOCLETHOME"));
        runtime.setVersion(XDocletPreferenceStore.getProperty("XDOCLETVERSION"));
        return runtime.isValid(XDocletPreferenceStore.getProperty("XDOCLETVERSION"));
    }

    public String getName() {
        return "XDocletAnnotionProvider";
    }

    public void generateSession(ISessionBean delegate, IProgressMonitor monitor) throws CoreException, InterruptedException {
        SessionBeanDataModel dataModel = (SessionBeanDataModel)delegate.getDataModel();
        String comment = "";
        String stub = "";
        String method = "";
        IConfigurationElement preferredAnnotation = EmitterUtilities.findEmitter((String)"XDoclet");
        try {
            SessionEjbEmitter ejbEmitter = new SessionEjbEmitter(preferredAnnotation);
            ejbEmitter.setMonitor(monitor);
            comment = ejbEmitter.emitTypeComment((IEnterpriseBean)delegate);
            stub = ejbEmitter.emitTypeStub((IEnterpriseBean)delegate);
            method = ejbEmitter.emitInterfaceMethods((IEnterpriseBean)delegate);
            ejbEmitter.deleteProject();
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.j2ee.ejb.annotation.model", 0, "Session EJB Emitters Failed", (Throwable)e));
        }
        EjbBuilder ejbBuilder = new EjbBuilder();
        ejbBuilder.setConfigurationElement(preferredAnnotation);
        ejbBuilder.setMonitor(monitor);
        ejbBuilder.setPackageFragmentRoot(dataModel.getJavaPackageFragmentRoot());
        ejbBuilder.setEnterpriseBeanDelegate((IEnterpriseBean)delegate);
        ejbBuilder.setTypeName(dataModel.getStringProperty("NewJavaClassDataModel.CLASS_NAME"));
        ejbBuilder.setPackageName(dataModel.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE"));
        ejbBuilder.setTypeComment(comment);
        ejbBuilder.setTypeStub(stub);
        ejbBuilder.setMethodStub(method);
        ejbBuilder.setFields("");
        ejbBuilder.createType();
        IType bean = ejbBuilder.getCreatedType();
        IResource javaFile = bean.getCorrespondingResource();
        IProject project = dataModel.getTargetProject();
        this.initializeBuilder(monitor, preferredAnnotation, javaFile, project);
        project.build(6, monitor);
    }

    public void generateMessageDriven(IMessageDrivenBean delegate, IProgressMonitor monitor) throws CoreException, InterruptedException {
        MessageDrivenBeanDataModel dataModel = (MessageDrivenBeanDataModel)delegate.getDataModel();
        String comment = "";
        String stub = "";
        String method = "";
        String fields = "";
        IConfigurationElement emitterConfiguration = EmitterUtilities.findEmitter((String)"XDoclet");
        try {
            MessageDrivenEjbEmitter ejbEmitter = new MessageDrivenEjbEmitter(emitterConfiguration);
            ejbEmitter.setMonitor(monitor);
            fields = ejbEmitter.emitFields((IEnterpriseBean)delegate);
            comment = ejbEmitter.emitTypeComment((IEnterpriseBean)delegate);
            stub = ejbEmitter.emitTypeStub((IEnterpriseBean)delegate);
            method = ejbEmitter.emitInterfaceMethods((IEnterpriseBean)delegate);
            ejbEmitter.deleteProject();
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.j2ee.ejb.annotation.model", 0, "MessageDriven EJB Emitters Failed", (Throwable)e));
        }
        EjbBuilder ejbBuilder = new EjbBuilder();
        ejbBuilder.setConfigurationElement(emitterConfiguration);
        ejbBuilder.setMonitor(monitor);
        ejbBuilder.setPackageFragmentRoot(dataModel.getJavaPackageFragmentRoot());
        ejbBuilder.setEnterpriseBeanDelegate((IEnterpriseBean)delegate);
        ejbBuilder.setTypeName(dataModel.getStringProperty("NewJavaClassDataModel.CLASS_NAME"));
        ejbBuilder.setPackageName(dataModel.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE"));
        ejbBuilder.setTypeComment(comment);
        ejbBuilder.setTypeStub(stub);
        ejbBuilder.setMethodStub(method);
        ejbBuilder.setFields(fields);
        ejbBuilder.createType();
        IType bean = ejbBuilder.getCreatedType();
        IResource javaFile = bean.getCorrespondingResource();
        IProject project = dataModel.getTargetProject();
        this.initializeBuilder(monitor, emitterConfiguration, javaFile, project);
        project.build(6, monitor);
    }

    protected void initializeBuilder(IProgressMonitor monitor, IConfigurationElement emitterConfiguration, IResource javaFile, IProject project) throws CoreException {
        EmitterUtilities.addAnnotationBuilderToProject((IConfigurationElement)emitterConfiguration, (IProject)project);
    }
}

