/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.ws.internal.common.EnvironmentUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;

public class PublishProjectCommand
extends SimpleCommand {
    private String DESCRIPTION = "Publish Web Project";
    private String LABEL = "PublishProjectCommand";
    private MessageUtils msgUtils_;
    private String project;
    private String serverTypeID;
    private IServer existingServer;

    public PublishProjectCommand() {
        String pluginId = "org.eclipse.jst.ws.consumption";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.setDescription(this.DESCRIPTION);
        this.setName(this.LABEL);
    }

    public Status execute(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        try {
            env.getProgressMonitor().report(this.msgUtils_.getMessage("PROGRESS_INFO_PUBLISH_WEB_PROJECT"));
            if (this.project == null) {
                status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_PROJECT_NOT_FOUND"), 4);
                env.getStatusHandler().reportError((Status)status);
                return status;
            }
            IProject iProject = (IProject)ResourceUtils.findResource((String)this.project);
            IServer instance = ServerUtils.getServerForModule((IModule)ResourceUtils.getModule((IProject)iProject), (String)this.serverTypeID, (IServer)this.existingServer, (boolean)true, (IProgressMonitor)EnvironmentUtils.getIProgressMonitor((Environment)env));
            if (instance == null) {
                status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_INSTANCE_NOT_FOUND"), 4);
                env.getStatusHandler().reportError((Status)status);
                return status;
            }
            IStatus returnedStatus = instance.publish(1, EnvironmentUtils.getIProgressMonitor((Environment)env));
            status = EnvironmentUtils.convertIStatusToStatus((IStatus)returnedStatus);
            env.getLog().log(0, 5026, (Object)this, "execute", (Object)new String("project=" + this.project + " successfully published"));
            return status;
        }
        catch (Exception e) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_PUBLISH"), 4, (Throwable)e);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
    }

    public void setProject(String project) {
        this.project = project;
    }

    public void setServerTypeID(String serverTypeID) {
        this.serverTypeID = serverTypeID;
    }

    public void setExistingServer(IServer existingServer) {
        this.existingServer = existingServer;
    }
}

