/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.resources.IProject;
import org.eclipse.jst.ws.internal.consumption.command.common.StartProjectCommand;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.server.core.IServer;

public class ManageServerStartUpCommand
extends SimpleCommand {
    private String DESCRIPTION = "Start Web Project";
    private String LABEL = "ServerStartUpManager";
    private MessageUtils msgUtils_;
    private Boolean isStartServiceEnabled_;
    private Boolean isTestServiceEnabled_;
    private IProject serviceProject_;
    private String serviceServerTypeId_;
    private IServer serviceExistingServer_;
    private IProject sampleProject_;
    private String sampleServerTypeId_;
    private IServer sampleExistingServer_;
    private boolean isWebProjectStartupRequested_;
    private String moduleName_;

    public ManageServerStartUpCommand(String moduleName) {
        String pluginId = "org.eclipse.jst.ws.consumption";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.moduleName_ = moduleName;
    }

    public Status execute(Environment env) {
        StartProjectCommand spc;
        SimpleStatus status = new SimpleStatus("");
        env.getProgressMonitor().report(this.msgUtils_.getMessage("PROGRESS_INFO_START_WEB_PROJECT"));
        if (this.isStartServiceEnabled_.booleanValue() && this.serviceExistingServer_ != null) {
            spc = new StartProjectCommand(this.moduleName_);
            spc.setServiceProject(this.serviceProject_);
            spc.setServiceServerTypeID(this.serviceServerTypeId_);
            spc.setServiceExistingServer(this.serviceExistingServer_);
            spc.setIsWebProjectStartupRequested(this.isWebProjectStartupRequested_);
            spc.execute(env);
        }
        if (this.isTestServiceEnabled_.booleanValue() && this.sampleExistingServer_ != null && this.serviceExistingServer_ != null && !this.sampleExistingServer_.equals(this.serviceExistingServer_)) {
            spc = new StartProjectCommand(this.moduleName_);
            spc.setSampleProject(this.sampleProject_);
            spc.setSampleServerTypeID(this.sampleServerTypeId_);
            spc.setSampleExistingServer(this.sampleExistingServer_);
            spc.setCreationScenario(new Boolean("false"));
            spc.execute(env);
        }
        return status;
    }

    public void setStartService(Boolean isStartServiceEnabled) {
        this.isStartServiceEnabled_ = isStartServiceEnabled;
    }

    public void setTestService(Boolean isTestServiceEnabled) {
        this.isTestServiceEnabled_ = isTestServiceEnabled;
    }

    public void setServiceExistingServer(IServer serviceExistingServer) {
        this.serviceExistingServer_ = serviceExistingServer;
    }

    public void setServiceServerTypeId(String serviceServerTypeId) {
        this.serviceServerTypeId_ = serviceServerTypeId;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject_ = serviceProject;
    }

    public void setSampleExistingServer(IServer sampleExistingServer) {
        this.sampleExistingServer_ = sampleExistingServer;
    }

    public void setSampleProject(IProject sampleProject) {
        this.sampleProject_ = sampleProject;
    }

    public void setSampleServerTypeId(String sampleServerTypeId) {
        this.sampleServerTypeId_ = sampleServerTypeId;
    }

    public void setIsWebProjectStartupRequested(boolean isRestartProjectNeeded) {
        this.isWebProjectStartupRequested_ = isRestartProjectNeeded;
    }
}

