/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.jst.ws.internal.ui.plugin.WebServiceUIPlugin;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.command.internal.provisional.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.provisional.env.core.context.ResourceDefaults;

public class ResourceManagmentPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private String INFOPOP_PPRM_PAGE = "org.eclipse.jst.ws.ui.PPRM0001";
    private Button overWriteFiles;
    private String INFOPOP_PPRM_CHECKBOX_OVERWRITE_FILES = "org.eclipse.jst.ws.ui.PPRM0002";
    private Button createFolders;
    private String INFOPOP_PPRM_CHECKBOX_CREATE_FOLDERS = "org.eclipse.jst.ws.ui.PPRM0003";
    private Button checkoutFiles;
    private String INFOPOP_PPRM_CHECKBOX_CHECK_OUT = "org.eclipse.jst.ws.ui.PPRM0004";

    protected Control createContents(Composite superparent) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        Composite parent = new Composite(superparent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        parent.setToolTipText(this.getMessage("%TOOLTIP_PPRM_PAGE"));
        helpSystem.setHelp((Control)parent, this.INFOPOP_PPRM_PAGE);
        this.overWriteFiles = this.createCheckBox(parent, WebServiceUIPlugin.getMessage("%BUTTON_OVERWRITE_FILES"));
        this.overWriteFiles.setToolTipText(this.getMessage("%TOOLTIP_PPRM_CHECKBOX_OVERWRITE_FILES"));
        helpSystem.setHelp((Control)this.overWriteFiles, this.INFOPOP_PPRM_CHECKBOX_OVERWRITE_FILES);
        this.createFolders = this.createCheckBox(parent, WebServiceUIPlugin.getMessage("%BUTTON_CREATE_FOLDERS"));
        this.createFolders.setToolTipText(this.getMessage("%TOOLTIP_PPRM_CHECKBOX_CREATE_FOLDERS"));
        helpSystem.setHelp((Control)this.createFolders, this.INFOPOP_PPRM_CHECKBOX_CREATE_FOLDERS);
        this.checkoutFiles = this.createCheckBox(parent, WebServiceUIPlugin.getMessage("%BUTTON_CHECKOUT_FILES"));
        this.checkoutFiles.setToolTipText(this.getMessage("%TOOLTIP_PPRM_CHECKBOX_CHECK_OUT"));
        helpSystem.setHelp((Control)this.checkoutFiles, this.INFOPOP_PPRM_CHECKBOX_CHECK_OUT);
        this.initializeValues();
        Dialog.applyDialogFont((Control)superparent);
        return parent;
    }

    private String getMessage(String key) {
        return WebServiceUIPlugin.getMessage(key);
    }

    private Button createCheckBox(Composite parent, String text) {
        Button button = new Button(parent, 32);
        button.setText(text);
        return button;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }

    protected void performApply() {
        this.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeDefaults() {
        this.overWriteFiles.setSelection(ResourceDefaults.getOverwriteFilesDefault());
        this.createFolders.setSelection(ResourceDefaults.getCreateFoldersDefault());
        this.checkoutFiles.setSelection(ResourceDefaults.getCheckoutFilesDefault());
    }

    private void initializeValues() {
        ResourceContext context = WebServicePlugin.getInstance().getResourceContext();
        this.overWriteFiles.setSelection(context.isOverwriteFilesEnabled());
        this.createFolders.setSelection(context.isCreateFoldersEnabled());
        this.checkoutFiles.setSelection(context.isCheckoutFilesEnabled());
    }

    private void storeValues() {
        ResourceContext context = WebServicePlugin.getInstance().getResourceContext();
        context.setOverwriteFilesEnabled(this.overWriteFiles.getSelection());
        context.setCreateFoldersEnabled(this.createFolders.getSelection());
        context.setCheckoutFilesEnabled(this.checkoutFiles.getSelection());
    }
}

