/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.Trace;

public class DeleteServerDialog
extends Dialog {
    protected IServer[] servers;
    protected IFolder[] configs;
    protected Button check;

    public DeleteServerDialog(Shell parentShell, IServer[] servers, IFolder[] configs) {
        super(parentShell);
        if (servers == null || configs == null) {
            throw new IllegalArgumentException();
        }
        this.servers = servers;
        this.configs = configs;
        this.setBlockOnOpen(true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.deleteServerResourceDialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        if (this.servers.length == 1) {
            label.setText(NLS.bind((String)Messages.deleteServerResourceDialogMessage, (Object)this.servers[0].getName()));
        } else {
            label.setText(NLS.bind((String)Messages.deleteServerResourceDialogMessageMany, (Object)String.valueOf(this.servers.length)));
        }
        label.setLayoutData((Object)new GridData());
        if (this.configs.length > 0) {
            this.check = new Button(composite, 32);
            if (this.configs.length == 1) {
                this.check.setText(NLS.bind((String)Messages.deleteServerResourceDialogLooseConfigurations, (Object)this.configs[0].getName()));
            } else {
                this.check.setText(NLS.bind((String)Messages.deleteServerResourceDialogLooseConfigurationsMany, (Object)String.valueOf(this.configs.length)));
            }
            this.check.setSelection(true);
            this.check.setLayoutData((Object)new GridData());
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        final boolean checked = this.check != null && this.check.getSelection();
        try {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    try {
                        int size = DeleteServerDialog.this.servers.length;
                        int i = 0;
                        while (i < size) {
                            DeleteServerDialog.this.servers[0].delete();
                            ++i;
                        }
                        if (checked) {
                            size = DeleteServerDialog.this.configs.length;
                            i = 0;
                            while (i < size) {
                                DeleteServerDialog.this.configs[i].delete(true, true, monitor);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(Trace.SEVERE, "Error while deleting resources", e);
                    }
                }
            };
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)op);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error deleting resources", e);
        }
        super.okPressed();
    }
}

