/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.ui.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class UIPlugin
extends AbstractUIPlugin {
    private static UIPlugin plugin;

    public UIPlugin() {
        plugin = this;
    }

    public UIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static UIPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle aResourceBundle = UIPlugin.getDefault().getResourceBundle();
        try {
            return aResourceBundle != null ? aResourceBundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getString(String key, Object s1) {
        return MessageFormat.format(UIPlugin.getResourceString(key), s1);
    }

    public static String getString(String key, Object s1, Object s2) {
        return MessageFormat.format(UIPlugin.getResourceString(key), s1, s2);
    }

    public ResourceBundle getResourceBundle() {
        try {
            return Platform.getResourceBundle((Bundle)plugin.getBundle());
        }
        catch (MissingResourceException x) {
            UIPlugin.log(x);
            return null;
        }
    }

    public ImageDescriptor getImageDescriptor(String name) {
        try {
            URL url = new URL(this.getBundle().getEntry("/"), name);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public Image getImage(String iconName) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        if (imageRegistry.get(iconName) != null) {
            return imageRegistry.get(iconName);
        }
        imageRegistry.put(iconName, ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)iconName));
        return imageRegistry.get(iconName);
    }

    public static String getPluginId() {
        return UIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        UIPlugin.getDefault().getLog().log(status);
    }

    public static void log(String message, Throwable e) {
        UIPlugin.log((IStatus)new Status(4, UIPlugin.getPluginId(), 4, message, e));
    }

    public static void log(String message) {
        UIPlugin.log((IStatus)new Status(4, UIPlugin.getPluginId(), 4, message, null));
    }

    public static void log(Throwable e) {
        UIPlugin.log((IStatus)new Status(4, UIPlugin.getPluginId(), 4, e.getLocalizedMessage(), e));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }
}

