/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.wizard;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.WebServiceType;
import org.eclipse.wst.command.internal.env.eclipse.EclipseLog;

public class WebServiceTypeRegistry {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    private static WebServiceTypeRegistry instance_;
    private Hashtable typesByName_;
    private String[] typeNames_;

    private void loadTypes() {
        EclipseLog log = new EclipseLog();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] config = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "webServiceType");
        int idx = 0;
        while (idx < config.length) {
            IConfigurationElement elem = config[idx];
            try {
                Object webServiceType = elem.createExecutableExtension("class");
                if (webServiceType instanceof WebServiceType) {
                    this.add((WebServiceType)webServiceType);
                } else {
                    String implementedInterface = "org.eclipse.jst.ws.ui.wizard.WebServiceType ";
                    String errMsg = "Extensions of the webServiceTypes extension point must implement the ";
                    errMsg = String.valueOf(errMsg) + implementedInterface + "interface.";
                    log.log(4, 5056, (Object)this, "loadTypes", (Object)errMsg);
                }
            }
            catch (CoreException e) {
                log.log(4, 5057, (Object)this, "loadTypes", (Throwable)e);
            }
            ++idx;
        }
    }

    private void load() {
        this.typesByName_ = new Hashtable();
        this.loadTypes();
        this.indexTypesByName();
    }

    private void add(WebServiceType wst) {
        this.typesByName_.put(wst.getName(), wst);
    }

    private void indexTypesByName() {
        if (this.typeNames_ == null) {
            this.typeNames_ = new String[this.typesByName_.size()];
            Enumeration e = this.typesByName_.keys();
            int i = 0;
            while (e.hasMoreElements()) {
                this.typeNames_[i] = (String)e.nextElement();
                ++i;
            }
        }
    }

    public static WebServiceTypeRegistry getInstance() {
        if (instance_ == null) {
            instance_ = new WebServiceTypeRegistry();
            instance_.load();
        }
        return instance_;
    }

    public WebServiceType[] getWebServiceTypes() {
        WebServiceType[] wsts = new WebServiceType[this.typesByName_.size()];
        Enumeration e = this.typesByName_.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            wsts[i] = (WebServiceType)e.nextElement();
            ++i;
        }
        return wsts;
    }

    public String[] getWebServiceTypeNames() {
        return this.typeNames_;
    }

    public WebServiceType getWebServiceTypeByName(String name) {
        return name == null ? null : (WebServiceType)this.typesByName_.get(name);
    }
}

