/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.wizard;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.ws.internal.consumption.fragments.ClientPreAssemblyFragment;
import org.eclipse.jst.ws.internal.consumption.fragments.ClientPreDeployFragment;
import org.eclipse.jst.ws.internal.consumption.fragments.ClientPreDevelopFragment;
import org.eclipse.jst.ws.internal.consumption.fragments.ClientPreInstallFragment;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.IWebServiceRuntime;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.WebServiceRuntime;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.WebServiceServer;
import org.eclipse.jst.ws.internal.data.LabelsAndIds;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragmentFactoryFactory;
import org.eclipse.wst.command.internal.env.core.registry.CommandRegistry;
import org.eclipse.wst.command.internal.env.ui.widgets.CanFinishRegistry;
import org.eclipse.wst.command.internal.env.ui.widgets.CommandWidgetBinding;
import org.eclipse.wst.command.internal.env.ui.widgets.CommandWidgetBindingList;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetRegistry;
import org.eclipse.wst.command.internal.provisional.env.core.data.DataMappingRegistry;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;

public class WebServiceClientTypeRegistry
implements CommandRegistry {
    private static WebServiceClientTypeRegistry instance_;
    private Vector configElems_;
    private HashSet typeNames_;
    private HashMap types_;
    private HashMap clientTypeAndIds_;
    private HashMap clientIdToLabel_;
    private HashMap webServiceServers;
    private HashMap webServiceRuntimes;
    private HashMap webServiceClientTypes;
    private DataMappingRegistry dataMappingRegistry_;
    private WidgetRegistry widgetRegistry_;
    private CanFinishRegistry canFinishRegistry_;
    private HashMap factoryCache_;

    private WebServiceClientTypeRegistry() {
    }

    private void loadTypes() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] config = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "webServiceClientType");
        int idx = 0;
        while (idx < config.length) {
            IConfigurationElement elem = config[idx];
            if (elem.getName().equals("webServiceServer")) {
                WebServiceServer wss = new WebServiceServer(elem);
                this.webServiceServers.put(elem.getAttribute("id"), wss);
            } else if (elem.getName().equals("webServiceRuntime")) {
                WebServiceRuntime rt = new WebServiceRuntime(elem);
                this.webServiceRuntimes.put(elem.getAttribute("id"), rt);
            } else if (elem.getName().equals("webServiceClientType")) {
                String name = elem.getAttribute("name");
                this.typeNames_.add(name);
                String typeId = elem.getAttribute("clientType");
                if (typeId == null) {
                    typeId = name;
                }
                String id = elem.getAttribute("id");
                this.clientTypeAndIds_.put(name, typeId);
                String serverId = elem.getAttribute("server");
                String runtimeId = elem.getAttribute("runtime");
                WebServiceServerRuntimeClientType wst = new WebServiceServerRuntimeClientType(serverId, runtimeId, typeId, name, elem);
                this.webServiceClientTypes.put(id, wst);
                this.types_.put(id, null);
                this.clientIdToLabel_.put(typeId, name);
            }
            this.configElems_.add(elem);
            ++idx;
        }
    }

    private void load() {
        this.typeNames_ = new HashSet();
        this.configElems_ = new Vector();
        this.types_ = new HashMap();
        this.clientTypeAndIds_ = new HashMap();
        this.webServiceClientTypes = new HashMap();
        this.webServiceRuntimes = new HashMap();
        this.webServiceServers = new HashMap();
        this.clientIdToLabel_ = new HashMap();
        this.loadTypes();
    }

    public static WebServiceClientTypeRegistry getInstance() {
        if (instance_ == null) {
            instance_ = new WebServiceClientTypeRegistry();
            instance_.load();
        }
        return instance_;
    }

    public WebServiceRuntime getRuntimeById(String id) {
        return (WebServiceRuntime)this.webServiceRuntimes.get(id);
    }

    public String[] getRuntimesByType(String typeId) {
        IConfigurationElement[] elems = this.getConfigurationElement(typeId);
        new Vector();
        String[] runtimeIds = new String[elems.length];
        int i = 0;
        while (i < elems.length) {
            IConfigurationElement elem = elems[i];
            runtimeIds[i] = elem.getAttribute("runtime");
            ++i;
        }
        return runtimeIds;
    }

    public boolean doesRuntimeSupportJ2EELevel(String j2eeVersionId, String runtimeId) {
        IWebServiceRuntime wsr = (IWebServiceRuntime)this.webServiceRuntimes.get(runtimeId);
        String[] j2eeVersions = wsr.getJ2EEVersions();
        if (j2eeVersions == null || j2eeVersions.length == 0) {
            return true;
        }
        int i = 0;
        while (i < j2eeVersions.length) {
            if (j2eeVersions[i].equals(j2eeVersionId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean doesRuntimeSupportServerTarget(String serverTargetId, String runtimeId) {
        Iterator it = this.webServiceClientTypes.values().iterator();
        while (it.hasNext()) {
            String thisServerTargetId;
            WebServiceServer wss;
            String thisFactoryId;
            IServerType serverType;
            WebServiceServerRuntimeClientType wssrt = (WebServiceServerRuntimeClientType)it.next();
            if (wssrt.runtimeId_ == null || !wssrt.runtimeId_.equalsIgnoreCase(runtimeId) || (serverType = ServerCore.findServerType((String)(thisFactoryId = (wss = (WebServiceServer)this.webServiceServers.get(wssrt.serverId_)).getFactoryId()))) == null || !(thisServerTargetId = serverType.getRuntimeType().getId()).equals(serverTargetId)) continue;
            return true;
        }
        return false;
    }

    public String[] getWebServiceClientTypeNames() {
        return this.typeNames_.toArray(new String[0]);
    }

    public LabelsAndIds getClientTypeLabels() {
        LabelsAndIds labelIds = new LabelsAndIds();
        Iterator iterator = this.clientIdToLabel_.entrySet().iterator();
        int size = this.clientIdToLabel_.size();
        String[] labels = new String[size];
        String[] ids = new String[size];
        int index = 0;
        labelIds.setLabels_(labels);
        labelIds.setIds_(ids);
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ids[index] = (String)entry.getKey();
            labels[index] = (String)entry.getValue();
            ++index;
        }
        return labelIds;
    }

    public IConfigurationElement getConfigurationElementFor(String serverId, String runtimeId, String typeId) {
        Iterator iter = this.webServiceClientTypes.values().iterator();
        while (iter.hasNext()) {
            WebServiceServerRuntimeClientType wssrt = (WebServiceServerRuntimeClientType)iter.next();
            if (!wssrt.hasConfigurationElementFor(serverId, runtimeId, typeId)) continue;
            return wssrt.element_;
        }
        return null;
    }

    public IConfigurationElement getConfigElementFor(String factoryId, String runtimeId, String typeId) {
        Iterator iter = this.webServiceClientTypes.values().iterator();
        while (iter.hasNext()) {
            WebServiceServerRuntimeClientType wssrt = (WebServiceServerRuntimeClientType)iter.next();
            if (!wssrt.hasConfigElementFor(factoryId, runtimeId, typeId)) continue;
            return wssrt.element_;
        }
        return null;
    }

    public String getClientExtensionIdFor(String serverId, String runtimeId, String typeId) {
        IConfigurationElement element = this.getConfigurationElementFor(serverId, runtimeId, typeId);
        return element.getAttribute("id");
    }

    public IConfigurationElement getConfigurationElementById(String id) {
        WebServiceServerRuntimeClientType wsrt = (WebServiceServerRuntimeClientType)this.webServiceClientTypes.get(id);
        return wsrt.element_;
    }

    public IConfigurationElement[] getConfigurationElement(String clientTypeId) {
        Vector<IConfigurationElement> v = new Vector<IConfigurationElement>();
        Iterator it = this.configElems_.iterator();
        while (it.hasNext()) {
            IConfigurationElement element = (IConfigurationElement)it.next();
            String clientType = element.getAttribute("clientType");
            if (clientType == null || !clientType.equals(clientTypeId)) continue;
            v.add(element);
        }
        return v.toArray(new IConfigurationElement[0]);
    }

    public IConfigurationElement[] getConfigurationElement(String clientTypeId, String runtimeId) {
        Vector<IConfigurationElement> v = new Vector<IConfigurationElement>();
        Iterator it = this.configElems_.iterator();
        while (it.hasNext()) {
            IConfigurationElement element = (IConfigurationElement)it.next();
            String clientType = element.getAttribute("clientType");
            String runtime = element.getAttribute("runtime");
            if (clientType == null || runtime == null || !clientType.equals(clientTypeId) || !runtime.equals(runtimeId)) continue;
            v.add(element);
        }
        return v.toArray(new IConfigurationElement[0]);
    }

    public String getServerIdForFactoryId(String factoryId) {
        Iterator iter = this.webServiceServers.values().iterator();
        while (iter.hasNext()) {
            WebServiceServer wss = (WebServiceServer)iter.next();
            if (!wss.getFactoryId().equals(factoryId)) continue;
            return wss.getId();
        }
        return null;
    }

    public String getServerFactoryIdByServerLabel(String label) {
        Iterator iter = this.webServiceServers.values().iterator();
        while (iter.hasNext()) {
            WebServiceServer wss = (WebServiceServer)iter.next();
            if (!wss.getLabel().equals(label)) continue;
            return wss.getFactoryId();
        }
        return null;
    }

    public WebServiceRuntime getWebServiceRuntimeByName(String runtimeName) {
        Iterator iter = this.webServiceRuntimes.values().iterator();
        while (iter.hasNext()) {
            WebServiceRuntime wsr = (WebServiceRuntime)iter.next();
            if (!wsr.getLabel().equals(runtimeName)) continue;
            return wsr;
        }
        return null;
    }

    public WebServiceServer getWebServiceServerByFactoryId(String factoryId) {
        Iterator iter = this.webServiceServers.values().iterator();
        while (iter.hasNext()) {
            WebServiceServer wss = (WebServiceServer)iter.next();
            if (!wss.getFactoryId().equals(factoryId)) continue;
            return wss;
        }
        return null;
    }

    public String getServerInstanceLabelFromInstanceId(String instanceId) {
        IServer server = ServerCore.findServer((String)instanceId);
        return server.getName();
    }

    public String[] getAllClientServerFactoryIds() {
        String[] serverFactoryIds = new String[this.webServiceServers.size()];
        int i = 0;
        Iterator iter = this.webServiceServers.values().iterator();
        while (iter.hasNext()) {
            WebServiceServer wss = (WebServiceServer)iter.next();
            if (wss.getFactoryId() == null) continue;
            serverFactoryIds[i] = wss.getFactoryId();
            ++i;
        }
        return serverFactoryIds;
    }

    public String[] getAllClientRuntimes() {
        String[] runtimes = new String[this.webServiceRuntimes.size()];
        int i = 0;
        Iterator iter = this.webServiceRuntimes.values().iterator();
        while (iter.hasNext()) {
            WebServiceRuntime wsr = (WebServiceRuntime)iter.next();
            if (wsr.getId() == null) continue;
            runtimes[i] = wsr.getId();
            ++i;
        }
        return runtimes;
    }

    public String getRuntimeLabelById(String runtimeId) {
        WebServiceRuntime wsRuntime = (WebServiceRuntime)this.webServiceRuntimes.get(runtimeId);
        if (wsRuntime != null) {
            return wsRuntime.getLabel();
        }
        return null;
    }

    public String getClientTypeIdByName(String name) {
        return (String)this.clientTypeAndIds_.get(name);
    }

    public IWebServiceRuntime getWebServiceRuntimeById(String runtimeId) {
        return (IWebServiceRuntime)this.webServiceRuntimes.get(runtimeId);
    }

    public String[] getRuntimeIdsByServerFactoryId(String serverFactoryID) {
        Vector<String> runtimeIds = new Vector<String>();
        Iterator it = this.webServiceClientTypes.values().iterator();
        while (it.hasNext()) {
            String serverId;
            WebServiceServer wss;
            String wssfId;
            WebServiceServerRuntimeClientType wssrt = (WebServiceServerRuntimeClientType)it.next();
            if (wssrt.serverId_ == null || !(wssfId = (wss = (WebServiceServer)this.webServiceServers.get(serverId = wssrt.serverId_)).getFactoryId()).equals(serverFactoryID)) continue;
            runtimeIds.add(wssrt.runtimeId_);
        }
        return runtimeIds.toArray(new String[0]);
    }

    public String[] getServerFactoryIdsByClientType(String clientTypeName) {
        Vector<String> factoryIds = new Vector<String>();
        String clientTypeId = this.getClientTypeIdByName(clientTypeName);
        Iterator iter = this.webServiceClientTypes.values().iterator();
        while (iter.hasNext()) {
            WebServiceServerRuntimeClientType wssrt = (WebServiceServerRuntimeClientType)iter.next();
            if (!wssrt.typeId_.equalsIgnoreCase(clientTypeId)) continue;
            WebServiceServer wss = (WebServiceServer)this.webServiceServers.get(wssrt.serverId_);
            factoryIds.add(wss.getFactoryId());
        }
        return factoryIds.toArray(new String[0]);
    }

    public String[] getServerFactoryIdsByRuntimeId(String runtimeID) {
        Vector<String> serverFactoryIds = new Vector<String>();
        Iterator it = this.webServiceClientTypes.values().iterator();
        while (it.hasNext()) {
            WebServiceServerRuntimeClientType wssrt = (WebServiceServerRuntimeClientType)it.next();
            if (wssrt.runtimeId_ == null || !wssrt.runtimeId_.equalsIgnoreCase(runtimeID)) continue;
            WebServiceServer wss = (WebServiceServer)this.webServiceServers.get(wssrt.serverId_);
            serverFactoryIds.add(wss.getFactoryId());
        }
        return serverFactoryIds.toArray(new String[0]);
    }

    public boolean webServiceClientRuntimeTypeExists(String serverId, String runtimeId, String typeId) {
        return this.getConfigurationElementFor(serverId, runtimeId, typeId) != null;
    }

    public String[] getServerFactoryIdsByType(String clientTypeId) {
        String clientTypeName = (String)this.clientIdToLabel_.get(clientTypeId);
        return this.getServerFactoryIdsByClientType(clientTypeName);
    }

    public boolean isServerSupportedForChosenType(String clientTypeId, String serverFactoryID) {
        String[] supportedServerFactoryIds = this.getServerFactoryIdsByType(clientTypeId);
        if (supportedServerFactoryIds != null && supportedServerFactoryIds.length > 0) {
            int i = 0;
            while (i < supportedServerFactoryIds.length) {
                if (supportedServerFactoryIds[i].equals(serverFactoryID)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public CommandFragmentFactoryFactory getFactoryFactory(String[] ids) {
        String hashKey = String.valueOf(ids[2]) + "#" + ids[1] + "#" + ids[0];
        CommandWidgetBinding binding = (CommandWidgetBinding)this.factoryCache_.get(hashKey);
        if (binding == null) {
            IConfigurationElement element = this.getConfigElementFor(ids[2], ids[1], ids[0]);
            if (element == null) {
                return null;
            }
            binding = this.createBinding(element);
            this.factoryCache_.put(hashKey, binding);
            binding.registerDataMappings(this.dataMappingRegistry_);
            if (this.widgetRegistry_ != null) {
                binding.registerWidgetMappings(this.widgetRegistry_);
                binding.registerCanFinish(this.canFinishRegistry_);
            }
        }
        return binding;
    }

    private CommandWidgetBinding createBinding(IConfigurationElement element) {
        Vector bindings = new Vector(4);
        Vector<Object> fragments = new Vector<Object>(4);
        this.addBinding(element, "developBinding", bindings);
        this.addBinding(element, "assemblyBinding", bindings);
        this.addBinding(element, "deployBinding", bindings);
        this.addBinding(element, "installBinding", bindings);
        fragments.add(new ClientPreDevelopFragment());
        fragments.add(new ClientPreAssemblyFragment());
        fragments.add(new ClientPreDeployFragment());
        fragments.add(new ClientPreInstallFragment());
        return new CommandWidgetBindingList(bindings, fragments);
    }

    private void addBinding(IConfigurationElement element, String bindingName, Vector list) {
        Object binding = null;
        if (element.getAttribute(bindingName) != null) {
            try {
                binding = element.createExecutableExtension(bindingName);
            }
            catch (CoreException coreException) {}
        }
        list.add(binding);
    }

    public void setDataMappingRegistry(DataMappingRegistry registry) {
        this.dataMappingRegistry_ = registry;
        this.factoryCache_ = new HashMap();
    }

    public void setWidgetRegistry(WidgetRegistry registry) {
        this.widgetRegistry_ = registry;
    }

    public void setCanFinishRegistry(CanFinishRegistry registry) {
        this.canFinishRegistry_ = registry;
    }

    public final class WebServiceServerRuntimeClientType {
        private String typeId_ = null;
        private String serverId_ = null;
        private String runtimeId_ = null;
        private IConfigurationElement element_;
        private boolean requiresServerRuntime_ = false;
        private String label_;

        protected WebServiceServerRuntimeClientType(String serverId, String runtimeId, String typeId, String label, IConfigurationElement elem) {
            this.typeId_ = new String(typeId.trim());
            if (serverId != null) {
                this.serverId_ = new String(serverId.trim());
            }
            if (runtimeId != null) {
                this.runtimeId_ = new String(runtimeId.trim());
            }
            this.element_ = elem;
            if (this.serverId_ != null && this.runtimeId_ != null) {
                this.requiresServerRuntime_ = true;
            }
            this.label_ = label;
        }

        public boolean hasConfigurationElementFor(String serverID, String runtimeID, String typeID) {
            if (this.typeId_.equalsIgnoreCase(typeID) && !this.requiresServerRuntime_) {
                return true;
            }
            return this.requiresServerRuntime_ && this.typeId_.equalsIgnoreCase(typeID) && this.serverId_.equalsIgnoreCase(serverID) && this.runtimeId_.equalsIgnoreCase(runtimeID);
        }

        public boolean hasConfigElementFor(String factoryID, String runtimeID, String typeID) {
            if (this.typeId_.equalsIgnoreCase(typeID) && !this.requiresServerRuntime_) {
                return true;
            }
            if (this.requiresServerRuntime_) {
                String serverID = WebServiceClientTypeRegistry.this.getServerIdForFactoryId(factoryID);
                if (this.typeId_.equalsIgnoreCase(typeID) && this.serverId_.equalsIgnoreCase(serverID) && this.runtimeId_.equalsIgnoreCase(runtimeID)) {
                    return true;
                }
            }
            return false;
        }

        public IConfigurationElement getClientTypeConfigurationElementFor(String serverID, String runtimeID, String typeID) {
            if (this.typeId_.equalsIgnoreCase(typeID) && serverID == null && runtimeID == null) {
                return this.element_;
            }
            if (this.typeId_.equalsIgnoreCase(typeID) && this.serverId_.equalsIgnoreCase(serverID) && this.runtimeId_.equalsIgnoreCase(runtimeID)) {
                return this.element_;
            }
            return null;
        }
    }
}

