/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test.wssample;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.ws.internal.common.EnvironmentUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.codegen.Generator;
import org.eclipse.jst.ws.internal.consumption.command.common.PublishProjectCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.StartProjectCommand;
import org.eclipse.jst.ws.internal.consumption.sampleapp.codegen.InputFileGenerator;
import org.eclipse.jst.ws.internal.consumption.sampleapp.codegen.MethodFileGenerator;
import org.eclipse.jst.ws.internal.consumption.sampleapp.codegen.ResultFileGenerator;
import org.eclipse.jst.ws.internal.consumption.sampleapp.codegen.TestClientFileGenerator;
import org.eclipse.jst.ws.internal.consumption.sampleapp.command.GeneratePageCommand;
import org.eclipse.jst.ws.internal.consumption.sampleapp.command.JavaToModelCommand;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.test.CopyWebServiceUtilsJarCommand;
import org.eclipse.jst.ws.internal.ext.test.JavaProxyTestCommand;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusException;
import org.eclipse.wst.command.internal.provisional.env.core.selection.BooleanSelection;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.ws.internal.datamodel.Model;

public class WSSampleFinishCommand
extends SimpleCommand
implements JavaProxyTestCommand {
    public static String INPUT = "Input.jsp";
    public static String TEST_CLIENT = "TestClient.jsp";
    public static String RESULT = "Result.jsp";
    public static String METHOD = "Method.jsp";
    private static String LABEL = "JavaBeanToSampleActiveTask";
    private static String DESCRIPTION = "default actions";
    private MessageUtils msgUtils;
    private Model proxyModel;
    private String sampleServerTypeID;
    private IServer sampleExistingServer;
    private String clientProject;
    private String qname;
    private String jspFolder;
    private boolean runClientTest;
    private String sampleProject;
    private BooleanSelection[] methods;
    private String proxyBean;
    private String setEndpointMethod;
    private List endpoints;

    public WSSampleFinishCommand() {
        String pluginId = "org.eclipse.jst.ws.consumption.ui";
        this.msgUtils = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.setDescription(DESCRIPTION);
        this.setName(LABEL);
    }

    public Status execute(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        CopyWebServiceUtilsJarCommand copy = new CopyWebServiceUtilsJarCommand();
        copy.setSampleProject(this.sampleProject);
        status = copy.execute(env);
        if (status.getSeverity() == 4) {
            return status;
        }
        status = this.createModel(env);
        if (status.getSeverity() == 4) {
            return status;
        }
        status = this.generatePages(env);
        if (status.getSeverity() == 4) {
            return status;
        }
        status = this.launchSample(env);
        return status;
    }

    protected Status generatePages(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        Path fDestinationFolderPath = new Path(this.jspFolder);
        fDestinationFolderPath = fDestinationFolderPath.makeAbsolute();
        IWorkspaceRoot fWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IPath pathTest = fDestinationFolderPath.append(TEST_CLIENT);
        IFile fileTest = fWorkspace.getFile(pathTest);
        GeneratePageCommand gpcTest = new GeneratePageCommand(EnvironmentUtils.getResourceContext((Environment)env), this.proxyModel, (Generator)new TestClientFileGenerator(INPUT, METHOD, RESULT), fileTest);
        status = gpcTest.execute(env);
        if (status.getSeverity() == 4) {
            return status;
        }
        IPath pathInput = fDestinationFolderPath.append(INPUT);
        IFile fileInput = fWorkspace.getFile(pathInput);
        InputFileGenerator inputGenerator = new InputFileGenerator(RESULT);
        GeneratePageCommand gpcInput = new GeneratePageCommand(EnvironmentUtils.getResourceContext((Environment)env), this.proxyModel, (Generator)inputGenerator, fileInput);
        status = gpcInput.execute(env);
        if (status.getSeverity() == 4) {
            return status;
        }
        IPath pathMethod = fDestinationFolderPath.append(METHOD);
        IFile fileMethod = fWorkspace.getFile(pathMethod);
        MethodFileGenerator methodGenerator = new MethodFileGenerator(INPUT);
        methodGenerator.setClientFolderPath(this.jspFolder);
        GeneratePageCommand gpcMethod = new GeneratePageCommand(EnvironmentUtils.getResourceContext((Environment)env), this.proxyModel, (Generator)methodGenerator, fileMethod);
        status = gpcMethod.execute(env);
        if (status.getSeverity() == 4) {
            return status;
        }
        IPath pathResult = fDestinationFolderPath.append(RESULT);
        IFile fileResult = fWorkspace.getFile(pathResult);
        ResultFileGenerator rfg = new ResultFileGenerator();
        rfg.setClientFolderPath(this.jspFolder);
        rfg.setSetEndpointMethod(this.setEndpointMethod);
        GeneratePageCommand gpcResult = new GeneratePageCommand(EnvironmentUtils.getResourceContext((Environment)env), this.proxyModel, (Generator)rfg, fileResult);
        status = gpcResult.execute(env);
        return status;
    }

    protected Status launchSample(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        if (!this.runClientTest) {
            return status;
        }
        Path fDestinationFolderPath = new Path(this.jspFolder);
        fDestinationFolderPath = fDestinationFolderPath.makeAbsolute();
        PublishProjectCommand ppc = new PublishProjectCommand();
        ppc.setServerTypeID(this.sampleServerTypeID);
        ppc.setExistingServer(this.sampleExistingServer);
        ppc.setProject(this.sampleProject);
        status = ppc.execute(env);
        StartProjectCommand spc = new StartProjectCommand(false);
        spc.setServiceServerTypeID(this.sampleServerTypeID);
        spc.setSampleExistingServer(this.sampleExistingServer);
        IProject project = (IProject)ResourceUtils.findResource((String)this.sampleProject);
        spc.setSampleProject(project);
        spc.setIsWebProjectStartupRequested(true);
        status = spc.execute(env);
        if (status.getSeverity() == 4) {
            return status;
        }
        Path newPath = new Path(ResourceUtils.getWebProjectURL((IProject)ResourceUtils.getProjectOf((IPath)fDestinationFolderPath), (String)this.sampleServerTypeID, (IServer)this.sampleExistingServer));
        newPath = newPath.append(fDestinationFolderPath.removeFirstSegments(2).makeAbsolute());
        StringBuffer urlString = new StringBuffer(newPath.append(TEST_CLIENT).toString());
        if (this.endpoints != null && !this.endpoints.isEmpty()) {
            urlString.append("?endpoint=");
            urlString.append(this.endpoints.get(0).toString());
        }
        try {
            URL url = new URL(urlString.toString());
            int retries = 0;
            while (retries < 10) {
                try {
                    new URL(newPath.append(RESULT).toString()).openStream();
                    new URL(newPath.append(METHOD).toString()).openStream();
                    new URL(newPath.append(INPUT).toString()).openStream();
                    new URL(newPath.append(TEST_CLIENT).toString()).openStream();
                    break;
                }
                catch (IOException iOException) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++retries;
                }
            }
            IWorkbenchBrowserSupport browserSupport = WebServiceConsumptionUIPlugin.getInstance().getWorkbench().getBrowserSupport();
            IWebBrowser browser = browserSupport.createBrowser(6, null, null, null);
            browser.openURL(url);
            return status;
        }
        catch (PartInitException exc) {
            env.getLog().log(2, 5048, (Object)this, "launchSample", (Throwable)exc);
            status = new SimpleStatus("launchSample", this.msgUtils.getMessage("MSG_ERROR_MALFORMED_URL"), 2);
            try {
                env.getStatusHandler().report((Status)status);
            }
            catch (StatusException statusException) {
                status = new SimpleStatus("launchSample", this.msgUtils.getMessage("MSG_ERROR_MALFORMED_URL"), 4);
            }
            return status;
        }
        catch (MalformedURLException exc) {
            env.getLog().log(2, 5048, (Object)this, "launchSample", (Throwable)exc);
            status = new SimpleStatus("launchSample", this.msgUtils.getMessage("MSG_ERROR_MALFORMED_URL"), 2);
            try {
                env.getStatusHandler().report((Status)status);
            }
            catch (StatusException statusException) {
                status = new SimpleStatus("launchSample", this.msgUtils.getMessage("MSG_ERROR_MALFORMED_URL"), 4);
            }
            return status;
        }
    }

    protected Status createModel(Environment env) {
        JavaToModelCommand jtmc = new JavaToModelCommand();
        jtmc.setMethods(this.methods);
        jtmc.setClientProject(this.clientProject);
        jtmc.setProxyBean(this.proxyBean);
        Status status = jtmc.execute(env);
        if (status.getSeverity() == 4) {
            return status;
        }
        this.proxyModel = jtmc.getDataModel();
        return status;
    }

    public void setServerTypeID(String sampleServerTypeID) {
        this.sampleServerTypeID = sampleServerTypeID;
    }

    public void setExistingServer(IServer sampleExistingServer) {
        this.sampleExistingServer = sampleExistingServer;
    }

    public void setJspFolder(String jspFolder) {
        this.jspFolder = jspFolder;
    }

    public void setRunClientTest(boolean runClientTest) {
        this.runClientTest = runClientTest;
    }

    public void setSampleProject(String sampleProject) {
        this.sampleProject = sampleProject;
    }

    public void setClientProject(String clientProject) {
        this.clientProject = clientProject;
    }

    public void setMethods(BooleanSelection[] methods) {
        this.methods = methods;
    }

    public void setProxyBean(String proxyBean) {
        this.proxyBean = proxyBean;
    }

    public void setSetEndpointMethod(String setEndpointMethod) {
        this.setEndpointMethod = setEndpointMethod;
    }

    public void setEndpoint(List endpoints) {
        this.endpoints = endpoints;
    }
}

