/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test;

import java.util.List;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestExtension;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestRegistry;
import org.eclipse.wst.command.internal.provisional.env.core.Command;
import org.eclipse.wst.command.internal.provisional.env.core.ICommandFactory;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusHandler;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.ws.internal.provisional.wsrt.IWebServiceTester;
import org.eclipse.wst.ws.internal.provisional.wsrt.TestInfo;

public class WSDLTestLaunchCommand
extends SimpleCommand {
    private String testID;
    private String launchedServiceTestName;
    private TypeRuntimeServer serviceids;
    private String serverProject;
    private String serverModule;
    private String wsdlURI;
    private MessageUtils msgUtils;
    private boolean externalBrowser;
    private List endpoints;
    private IServer serviceExistingServer = null;
    private String serviceServerTypeID = null;
    private String serviceServerInstanceId = null;

    public WSDLTestLaunchCommand() {
        String pluginId = "org.eclipse.jst.ws.consumption.ui";
        this.msgUtils = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
    }

    public Status execute(Environment env) {
        TestInfo testInfo;
        SimpleStatus status = new SimpleStatus("");
        WebServiceTestRegistry testRegistry = WebServiceTestRegistry.getInstance();
        WebServiceTestExtension wscte = (WebServiceTestExtension)testRegistry.getWebServiceExtensionsByName(this.testID);
        IWebServiceTester iwst = (IWebServiceTester)wscte.getWebServiceExecutableExtension();
        status = this.commandFactoryExecution(iwst.launch(testInfo = this.getTestInfo()), env);
        if (status.getSeverity() != 0) {
            StatusHandler sHandler = env.getStatusHandler();
            SimpleStatus infoStatus = new SimpleStatus("", this.msgUtils.getMessage("MSG_ERROR_UNABLE_TO_LAUNCH_WSDL_TEST"), 1);
            sHandler.reportInfo((Status)infoStatus);
            return infoStatus;
        }
        return status;
    }

    private Status commandFactoryExecution(ICommandFactory commandFactory, Environment env) {
        SimpleStatus status = new SimpleStatus("");
        while (commandFactory.hasNext()) {
            Command command = commandFactory.getNextCommand();
            if (command != null) {
                status = command.execute(env);
            }
            if (status.getSeverity() != 4) continue;
            StatusHandler sHandler = env.getStatusHandler();
            sHandler.reportError((Status)status);
            return status;
        }
        return status;
    }

    private TestInfo getTestInfo() {
        if (this.serviceids.getServerInstanceId() != null) {
            this.serviceExistingServer = ServerCore.findServer((String)this.serviceids.getServerInstanceId());
        } else if (this.serviceServerInstanceId != null) {
            this.serviceExistingServer = ServerCore.findServer((String)this.serviceServerInstanceId);
        }
        this.serviceServerTypeID = this.serviceExistingServer != null ? this.serviceExistingServer.getServerType().getId() : this.serviceids.getServerId();
        TestInfo testInfo = new TestInfo();
        if (this.serviceExistingServer != null) {
            testInfo.setServiceExistingServer(this.serviceExistingServer);
        }
        testInfo.setServiceServerTypeID(this.serviceServerTypeID);
        testInfo.setServiceProject(this.serverProject);
        testInfo.setWsdlServiceURL(this.wsdlURI);
        testInfo.setEndpoint(this.endpoints);
        return testInfo;
    }

    public void setTestID(String testID) {
        this.testID = testID;
    }

    public String getLaunchedServiceTestName() {
        return this.launchedServiceTestName;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public void setServerProject(String serverProject) {
        this.serverProject = serverProject;
    }

    public void setServiceTypeRuntimeServer(TypeRuntimeServer serviceids) {
        this.serviceids = serviceids;
    }

    public void setExternalBrowser(boolean externalBrowser) {
        this.externalBrowser = externalBrowser;
    }

    public void setEndpoint(List endpoints) {
        this.endpoints = endpoints;
    }

    public String getServerModule() {
        return this.serverModule;
    }

    public void setServerModule(String serverModule) {
        this.serverModule = serverModule;
    }

    public void setServiceServerInstanceId(String ssInstanceId) {
        this.serviceServerInstanceId = ssInstanceId;
    }
}

