/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.webservice.WebServiceNavigatorGroupType;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServicesManager;
import org.eclipse.jst.j2ee.webservice.wsdd.Handler;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddResource;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.AbstractHandlersWidgetDefaultingCmd;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.HandlerTableItem;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.internal.impl.ServiceImpl;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;

public class ServiceHandlersWidgetDefaultingCommand
extends AbstractHandlersWidgetDefaultingCmd {
    private HandlerTableItem[] handlers_;
    private MessageUtils msgUtils_;
    private boolean isGenSkeletonEnabled_;
    private IPath sourceOutputLocation_;
    private WebServiceDescription wsDescription_;
    private WsddResource wsddResource_;
    private WebServicesManager webServicesManager_;
    private IProject project_;
    private Hashtable wsDescToHandlers_;
    private Hashtable serviceDescNameToDescObj_;
    private String descriptionName_ = null;

    public Status execute(Environment env) {
        String pluginId = "org.eclipse.jst.ws.consumption.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        SimpleStatus status = new SimpleStatus("");
        this.webServicesManager_ = new WebServicesManager();
        IStructuredSelection selection = this.getInitialSelection();
        if (selection == null) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_TASK_EXCEPTED"), 4, null);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        status = this.processHandlers(env);
        return status;
    }

    public Status processHandlers(Environment env) {
        try {
            Vector<HandlerTableItem> handlers = new Vector<HandlerTableItem>();
            this.wsDescToHandlers_ = new Hashtable();
            this.serviceDescNameToDescObj_ = new Hashtable();
            this.wsddResource_ = this.getWsddResourceFromSelection();
            if (this.wsddResource_ == null) {
                SimpleStatus status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_TASK_EXCEPTED"), 4, null);
                env.getStatusHandler().reportError((Status)status);
                return status;
            }
            WebServices webServices = this.wsddResource_.getWebServices();
            if (webServices != null) {
                EList wsDescriptions = this.wsddResource_.getWebServices().getWebServiceDescriptions();
                int i = 0;
                while (i < wsDescriptions.size()) {
                    this.wsDescription_ = (WebServiceDescription)wsDescriptions.get(i);
                    EList wsPortComponents = this.wsDescription_.getPortComponents();
                    int j = 0;
                    while (j < wsPortComponents.size()) {
                        PortComponent wsPort = (PortComponent)wsPortComponents.get(j);
                        String portName = wsPort.getPortComponentName();
                        EList wsHandlers = wsPort.getHandlers();
                        HandlerTableItem[] handlerItems = new HandlerTableItem[wsHandlers.size()];
                        int k = 0;
                        while (k < wsHandlers.size()) {
                            Handler wsHandler = (Handler)wsHandlers.get(k);
                            HandlerTableItem handlerItem = new HandlerTableItem();
                            handlerItem.setHandler(wsHandler);
                            handlerItem.setHandlerName(wsHandler.getHandlerName());
                            handlerItem.setHandlerClassName(wsHandler.getHandlerClass());
                            handlerItem.setPort(wsPort);
                            handlerItem.setPortName(portName);
                            handlerItem.setWsDescRef(this.wsDescription_);
                            handlerItems[k] = handlerItem;
                            handlers.add(handlerItem);
                            ++k;
                        }
                        String wsDescName = this.wsDescription_.getWebServiceDescriptionName();
                        this.wsDescToHandlers_.put(wsDescName, handlerItems);
                        this.serviceDescNameToDescObj_.put(wsDescName, this.wsDescription_);
                        ++j;
                    }
                    ++i;
                }
                this.handlers_ = handlers.toArray(new HandlerTableItem[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_TASK_EXCEPTED"), 4, (Throwable)e);
        }
        return new SimpleStatus("");
    }

    public HandlerTableItem[] getHandlers() {
        return this.handlers_;
    }

    public boolean getGenSkeletonEnabled() {
        return true;
    }

    public IPath[] getSourceOutputLocation() {
        IPath[] locations = null;
        IProject project = this.getProject();
        if (project != null) {
            locations = ResourceUtils.getAllJavaSourceLocations((IProject)project);
        } else {
            project = this.project_;
            if (project != null) {
                locations = ResourceUtils.getAllJavaSourceLocations((IProject)project);
            }
        }
        return locations;
    }

    public WsddResource getWsddResource() {
        return this.wsddResource_;
    }

    private WsddResource getWsddResourceFromSelection() {
        IStructuredSelection initSel = this.getInitialSelection();
        if (initSel != null && initSel.size() == 1) {
            Object obj = initSel.getFirstElement();
            if (obj instanceof ServiceImpl) {
                Service service = (Service)obj;
                this.descriptionName_ = service.getQName().getLocalPart();
                this.project_ = ProjectUtilities.getProject((EObject)service);
                return this.webServicesManager_.getWsddResource((EObject)service);
            }
            if (obj instanceof WSDLResourceImpl) {
                WSDLResourceImpl res = (WSDLResourceImpl)obj;
                this.project_ = ProjectUtilities.getProject((Resource)res);
                List wsdlResources = this.webServicesManager_.getWSDLServices((Resource)res);
                return this.webServicesManager_.getWsddResource((EObject)((Service)wsdlResources.get(0)));
            }
            if (obj instanceof WebServiceNavigatorGroupType) {
                WebServiceNavigatorGroupType wsngt = (WebServiceNavigatorGroupType)obj;
                Service service = (Service)wsngt.getWsdlService();
                this.descriptionName_ = service.getQName().getLocalPart();
                this.project_ = ProjectUtilities.getProject((EObject)service);
                return this.webServicesManager_.getWsddResource((EObject)service);
            }
        }
        return null;
    }

    public WebServiceDescription getWsDescription() {
        return this.wsDescription_;
    }

    public String getDescriptionName() {
        return this.descriptionName_;
    }

    public Hashtable getWsRefsToHandlers() {
        return this.wsDescToHandlers_;
    }

    public Hashtable getServiceDescNameToDescObj() {
        return this.serviceDescNameToDescObj_;
    }
}

