/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.j2ee.internal.servertarget.ServerTargetHelper;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.common.IServerDefaulter;
import org.eclipse.jst.ws.internal.consumption.common.ServerInfo;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.jst.ws.internal.consumption.ui.preferences.PersistentServerRuntimeContext;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.WebServiceServerRuntimeTypeRegistry;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeInfo;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;

public class ServerSelectionUtils {
    public static String[] getServerInfoFromExistingProject(IProject project, String componentName, String runtimeId, boolean askExtenders) {
        ServerInfo recommendedServerInfo;
        String[] serverInfo = new String[2];
        IServer[] configuredServers = ServerUtil.getServersByModule((IModule)ServerUtils.getModule((IProject)project, (String)componentName), null);
        IServer firstSupportedServer = ServerSelectionUtils.getFirstSupportedServer(configuredServers, runtimeId);
        if (firstSupportedServer != null) {
            serverInfo[0] = firstSupportedServer.getServerType().getId();
            serverInfo[1] = firstSupportedServer.getId();
            return serverInfo;
        }
        IRuntime runtimeTarget = ServerSelectionUtils.getRuntimeTarget(project.getName());
        if (runtimeTarget != null) {
            String serverRuntimeId;
            IServer firstSupportedCompatServer;
            IServer[] compatibleServers = ServerSelectionUtils.getCompatibleExistingServers(runtimeTarget);
            if (compatibleServers != null && compatibleServers.length > 0 && (firstSupportedCompatServer = ServerSelectionUtils.getFirstSupportedServer(compatibleServers, runtimeId)) != null) {
                serverInfo[0] = firstSupportedCompatServer.getServerType().getId();
                serverInfo[1] = firstSupportedCompatServer.getId();
                return serverInfo;
            }
            PersistentServerRuntimeContext ctx = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
            String pFactoryId = ctx.getServerFactoryId();
            IServerType serverType = ServerCore.findServerType((String)pFactoryId);
            if (serverType != null && (serverRuntimeId = serverType.getRuntimeType().getId()).equals(runtimeTarget.getRuntimeType().getId())) {
                serverInfo[0] = pFactoryId;
                return serverInfo;
            }
            String factoryId = ServerSelectionUtils.getFirstSupportedServerType(runtimeTarget, runtimeId);
            if (factoryId != null) {
                serverInfo[0] = factoryId;
            }
            return serverInfo;
        }
        if (askExtenders && (recommendedServerInfo = ServerSelectionUtils.getExtenderRecommendation(project)) != null) {
            if (recommendedServerInfo.getServerFactoryId() != null && recommendedServerInfo.getServerFactoryId().length() > 0) {
                serverInfo[0] = recommendedServerInfo.getServerFactoryId();
            }
            if (recommendedServerInfo.getServerInstanceId() != null && recommendedServerInfo.getServerInstanceId().length() > 0) {
                serverInfo[1] = recommendedServerInfo.getServerInstanceId();
            }
            return serverInfo;
        }
        String[] projectAttrs = ServerTargetHelper.getProjectTypeAndJ2EELevel((IProject)project);
        List runtimes = ServerTargetHelper.getServerTargets((String)projectAttrs[0], (String)projectAttrs[1]);
        String[] compatServerInfo = ServerSelectionUtils.getCompatibleExistingServer(runtimes, runtimeId);
        if (compatServerInfo != null) {
            return compatServerInfo;
        }
        String factoryId = ServerSelectionUtils.getFirstSupportedServerType(runtimes, runtimeId);
        if (factoryId != null) {
            serverInfo[0] = factoryId;
        }
        return serverInfo;
    }

    public static IServer getFirstSupportedServer(IServer[] servers, String webServiceRuntimeId) {
        if (servers != null && servers.length > 0) {
            int i = 0;
            while (i < servers.length) {
                String serverFactoryId = servers[i].getServerType().getId();
                if (WebServiceRuntimeExtensionUtils.doesRuntimeSupportServer(webServiceRuntimeId, serverFactoryId)) {
                    return servers[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static String getFirstSupportedServerType(IRuntime runtimeTarget, String webServiceRuntimeId) {
        String runtimeId = runtimeTarget.getRuntimeType().getId();
        WebServiceRuntimeInfo wsrt = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(webServiceRuntimeId);
        String[] serverFactoryIds = wsrt.getServerFactoryIds();
        int i = 0;
        while (i < serverFactoryIds.length) {
            String serverRuntimeId;
            IServerType serverType = ServerCore.findServerType((String)serverFactoryIds[i]);
            if (serverType != null && (serverRuntimeId = serverType.getRuntimeType().getId()).equals(runtimeId)) {
                return serverFactoryIds[i];
            }
            ++i;
        }
        return null;
    }

    public static String getFirstSupportedServerType(List runtimeTargets, String webServiceRuntimeId) {
        int i = 0;
        while (i < runtimeTargets.size()) {
            IRuntime runtimeTarget = (IRuntime)runtimeTargets.get(i);
            String factoryId = ServerSelectionUtils.getFirstSupportedServerType(runtimeTarget, webServiceRuntimeId);
            if (factoryId != null && factoryId.length() > 0) {
                return factoryId;
            }
            ++i;
        }
        return null;
    }

    public static IRuntime getRuntimeTarget(String projectName) {
        IProject project;
        if (projectName != null && projectName.length() > 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && project.exists()) {
            return ServerCore.getProjectProperties((IProject)project).getRuntimeTarget();
        }
        return null;
    }

    public static IServer getFirstExistingServerFromFactoryId(String factoryId) {
        IServer[] servers = ServerCore.getServers();
        if (servers == null || servers.length != 0) {
            return null;
        }
        int i = 0;
        while (i < servers.length) {
            IServer server = servers[i];
            if (server.getServerType().getId().equals(factoryId)) {
                return server;
            }
            ++i;
        }
        return null;
    }

    public static IServer[] getCompatibleExistingServers(IRuntime runtime) {
        if (runtime == null) {
            return null;
        }
        IServer[] servers = ServerCore.getServers();
        if (servers == null || servers.length == 0) {
            return null;
        }
        ArrayList<IServer> compatibleServersList = new ArrayList<IServer>();
        String runtimeId = runtime.getRuntimeType().getId();
        int i = 0;
        while (i < servers.length) {
            IServer server = servers[i];
            String serverRuntimeId = server.getRuntime().getRuntimeType().getId();
            if (serverRuntimeId.equals(runtimeId)) {
                compatibleServersList.add(server);
            }
            ++i;
        }
        if (compatibleServersList.size() < 1) {
            return null;
        }
        Object[] compatibleServersArray = compatibleServersList.toArray();
        IServer[] compatibleServers = new IServer[compatibleServersArray.length];
        int j = 0;
        while (j < compatibleServersArray.length) {
            compatibleServers[j] = (IServer)compatibleServersArray[j];
            ++j;
        }
        return compatibleServers;
    }

    public static String[] getCompatibleExistingServer(List runtimeTargets, String webServiceRuntimeId) {
        String[] serverInfo = new String[2];
        int i = 0;
        while (i < runtimeTargets.size()) {
            IRuntime runtimeTarget = (IRuntime)runtimeTargets.get(i);
            IServer[] existingCompatServers = ServerSelectionUtils.getCompatibleExistingServers(runtimeTarget);
            IServer compatServer = ServerSelectionUtils.getFirstSupportedServer(existingCompatServers, webServiceRuntimeId);
            if (compatServer != null) {
                serverInfo[0] = compatServer.getServerType().getId();
                serverInfo[1] = compatServer.getId();
                return serverInfo;
            }
            ++i;
        }
        return null;
    }

    public static ServerInfo getExtenderRecommendation(IProject project) {
        try {
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption", "serverDefaulter");
            int i = 0;
            while (i < elements.length) {
                IServerDefaulter serverDefaulter;
                ServerInfo serverInfo;
                Object serverDefaulterObject = elements[i].createExecutableExtension("class");
                if (serverDefaulterObject instanceof IServerDefaulter && (serverInfo = (serverDefaulter = (IServerDefaulter)serverDefaulterObject).recommendDefaultServer(project)) != null) {
                    return serverInfo;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }

    private static List getRuntimeTargetsSupportedByWSRuntime(List runtimeTargets, String webServiceRuntimeId) {
        ArrayList<IRuntime> suppRuntimeTargets = new ArrayList<IRuntime>();
        WebServiceServerRuntimeTypeRegistry wssrtReg = WebServiceServerRuntimeTypeRegistry.getInstance();
        int i = 0;
        while (i < runtimeTargets.size()) {
            IRuntime runtimeTarget = (IRuntime)runtimeTargets.get(i);
            String rtId = runtimeTarget.getRuntimeType().getId();
            if (wssrtReg.doesRuntimeSupportServerTarget(rtId, webServiceRuntimeId)) {
                // empty if block
            }
            suppRuntimeTargets.add(runtimeTarget);
            ++i;
        }
        return suppRuntimeTargets;
    }

    public static String[] getServerFromWebServceRuntimeAndJ2EE(String webServiceRuntimeId, String j2eeVersion) {
        String thisFactoryId;
        IServer server;
        int i;
        boolean preferredIsValid;
        String[] serverInfo = new String[2];
        WebServiceRuntimeInfo wsrt = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(webServiceRuntimeId);
        String[] validServerFactoryIds = wsrt.getServerFactoryIds();
        if (validServerFactoryIds == null || validServerFactoryIds.length < 1) {
            return null;
        }
        IServer[] servers = ServerCore.getServers();
        PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
        String prefServerFactoryId = context.getServerFactoryId();
        boolean bl = preferredIsValid = ServerSelectionUtils.containsString(validServerFactoryIds, prefServerFactoryId) && ServerSelectionUtils.isServerValid(prefServerFactoryId, j2eeVersion);
        if (preferredIsValid) {
            i = 0;
            while (i < servers.length) {
                server = servers[i];
                thisFactoryId = server.getServerType().getId();
                if (thisFactoryId.equals(prefServerFactoryId)) {
                    serverInfo[0] = prefServerFactoryId;
                    serverInfo[1] = server.getId();
                    return serverInfo;
                }
                ++i;
            }
        }
        i = 0;
        while (i < servers.length) {
            boolean thisServerValid;
            server = servers[i];
            thisFactoryId = server.getServerType().getId();
            boolean bl2 = thisServerValid = ServerSelectionUtils.containsString(validServerFactoryIds, thisFactoryId) && ServerSelectionUtils.isServerValid(thisFactoryId, j2eeVersion);
            if (thisServerValid) {
                serverInfo[0] = thisFactoryId;
                serverInfo[1] = server.getId();
                return serverInfo;
            }
            ++i;
        }
        if (preferredIsValid) {
            serverInfo[0] = prefServerFactoryId;
            return serverInfo;
        }
        i = 0;
        while (i < validServerFactoryIds.length) {
            boolean isValid = ServerSelectionUtils.isServerValid(validServerFactoryIds[i], j2eeVersion);
            if (isValid) {
                serverInfo[0] = validServerFactoryIds[i];
                return serverInfo;
            }
            ++i;
        }
        return null;
    }

    private static boolean isServerValid(String serverFactoryId, String j2eeVersion) {
        if (serverFactoryId == null || serverFactoryId.length() == 0 || j2eeVersion == null || j2eeVersion.length() == 0) {
            return true;
        }
        String runtimeTargetId = ServerUtils.getRuntimeTargetIdFromFactoryId((String)serverFactoryId);
        if (runtimeTargetId == null || runtimeTargetId.length() == 0) {
            return false;
        }
        String webModuleType = "j2ee.web";
        boolean isValid = ServerUtils.isTargetValidForProjectType((String)runtimeTargetId, (String)j2eeVersion, (String)webModuleType);
        return isValid;
    }

    private static boolean containsString(String[] a, String b) {
        if (a == null || a.length < 0 || b == null || b.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            String s = a[i];
            if (s.equals(b)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

